/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.Collections;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.Transactor;
import org.neo4j.kernel.impl.api.constraints.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class ConstraintIndexCreator {
    private final Transactor transactor;
    private final IndexingService indexingService;

    public ConstraintIndexCreator(Transactor transactor, IndexingService indexingService) {
        this.transactor = transactor;
        this.indexingService = indexingService;
    }

    public long createUniquenessConstraintIndex(SchemaReadOperations schema, long labelId, long propertyKeyId) throws SchemaKernelException, ConstraintVerificationFailedKernelException, TransactionalException {
        long indexId;
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        IndexDescriptor descriptor = this.transactor.execute(ConstraintIndexCreator.createConstraintIndex(labelId, propertyKeyId));
        try {
            indexId = schema.indexGetCommittedId(descriptor);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor));
        }
        boolean success = false;
        try {
            this.awaitIndexPopulation(constraint, indexId);
            success = true;
        }
        catch (InterruptedException exception) {
            throw new ConstraintVerificationFailedKernelException(constraint, (Throwable)exception);
        }
        finally {
            if (!success) {
                this.dropUniquenessConstraintIndex(descriptor);
            }
        }
        return indexId;
    }

    public void validateConstraintIndex(UniquenessConstraint constraint, long indexId) throws ConstraintCreationKernelException {
        try {
            this.indexingService.validateIndex(indexId);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable failure = e.getCause();
            if (failure instanceof ConstraintVerificationFailedKernelException) {
                throw new ConstraintCreationKernelException(constraint, failure);
            }
            if (failure instanceof IndexEntryConflictException) {
                IndexEntryConflictException conflict = (IndexEntryConflictException)failure;
                throw new ConstraintCreationKernelException(constraint, (Throwable)new ConstraintVerificationFailedKernelException(constraint, Collections.singleton(new ConstraintVerificationFailedKernelException.Evidence(conflict))));
            }
            throw new ConstraintCreationKernelException(constraint, failure);
        }
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws SchemaKernelException, TransactionalException {
        this.transactor.execute(ConstraintIndexCreator.dropConstraintIndex(descriptor));
    }

    private void awaitIndexPopulation(UniquenessConstraint constraint, long indexId) throws InterruptedException, ConstraintVerificationFailedKernelException {
        try {
            this.indexingService.getProxyForRule(indexId).awaitStoreScanCompleted();
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new ConstraintVerificationFailedKernelException(constraint, Collections.singleton(new ConstraintVerificationFailedKernelException.Evidence((IndexEntryConflictException)cause)));
            }
            throw new ConstraintVerificationFailedKernelException(constraint, cause);
        }
    }

    private static Transactor.Statement<IndexDescriptor, SchemaKernelException> createConstraintIndex(final long labelId, final long propertyKeyId) {
        return new Transactor.Statement<IndexDescriptor, SchemaKernelException>(){

            @Override
            public IndexDescriptor perform(StatementContext statement) throws SchemaKernelException {
                return statement.uniqueIndexCreate(labelId, propertyKeyId);
            }
        };
    }

    private static Transactor.Statement<Void, SchemaKernelException> dropConstraintIndex(final IndexDescriptor descriptor) {
        return new Transactor.Statement<Void, SchemaKernelException>(){

            @Override
            public Void perform(StatementContext statement) throws SchemaKernelException {
                statement.uniqueIndexDrop(descriptor);
                return null;
            }
        };
    }
}

