/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.operations.KeyNameLookup;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private static final String message = "Unable to create constraint [label: %s, %s] : %s";
    private final long labelId;
    private final long propertyKey;

    public CreateConstraintFailureException(long labelId, long propertyKey, SchemaKernelException cause) {
        super(String.format(message, labelId, propertyKey, cause), cause);
        this.labelId = labelId;
        this.propertyKey = propertyKey;
    }

    @Override
    public String getUserMessage(KeyNameLookup nameLookup) {
        return String.format(message, nameLookup.getLabelName(this.labelId), nameLookup.getPropertyKeyName(this.propertyKey), ((KernelException)this.getCause()).getUserMessage(nameLookup));
    }
}

