/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class StoreLocker {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    private final Config configuration;
    private final FileSystemAbstraction fileSystemAbstraction;
    private FileLock storeLockFileLock;
    private FileChannel storeLockFileChannel;

    public StoreLocker(Config configuration, FileSystemAbstraction fileSystemAbstraction) {
        this.configuration = configuration;
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void checkLock(File storeDir) throws StoreLockException {
        File storeLockFile = new File(storeDir, STORE_LOCK_FILENAME);
        try {
            if (!this.fileSystemAbstraction.fileExists(storeLockFile)) {
                if (this.configuration.get(GraphDatabaseSettings.read_only).booleanValue()) {
                    String msg = "Unable to lock store as store dir does not exist and instance is in read-only mode";
                    throw new StoreLockException(msg);
                }
                this.fileSystemAbstraction.mkdirs(storeLockFile.getParentFile());
            }
        }
        catch (IOException e) {
            throw new StoreLockException("Unable to create path for store dir: " + storeDir, e);
        }
        try {
            this.storeLockFileChannel = this.fileSystemAbstraction.open(storeLockFile, "rw");
            this.storeLockFileLock = this.fileSystemAbstraction.tryLock(storeLockFile, this.storeLockFileChannel);
            if (this.storeLockFileLock == null) {
                throw new StoreLockException("Could not create lock file");
            }
        }
        catch (OverlappingFileLockException e) {
            throw new StoreLockException("Unable to obtain lock on store lock file: " + storeLockFile, e);
        }
        catch (IOException e) {
            throw new StoreLockException("Unable to obtain lock on store lock file: " + storeLockFile, e);
        }
    }

    public void release() throws IOException {
        if (this.storeLockFileLock != null) {
            this.storeLockFileLock.release();
            this.storeLockFileLock = null;
        }
        if (this.storeLockFileChannel != null) {
            this.storeLockFileChannel.close();
            this.storeLockFileChannel = null;
        }
    }
}

