/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Predicate;
import org.neo4j.tooling.Clock;

public abstract class CappedOperation<T> {
    private final Switch<T> opener;

    public CappedOperation(Switch ... openers) {
        this.opener = CappedOperation.firstOccurenceOf(openers);
    }

    public void event(T event) {
        if (this.opener.accept(event)) {
            this.triggered(event);
        }
    }

    protected abstract void triggered(T var1);

    private static <T> Switch<T> firstOccurenceOf(final Switch ... filters) {
        for (Switch filter : filters) {
            filter.reset();
        }
        return new Switch<T>(){

            @Override
            public synchronized boolean accept(T item) {
                boolean accepted = false;
                for (Switch filter : filters) {
                    if (!filter.accept(item)) continue;
                    accepted = true;
                }
                if (accepted) {
                    this.reset();
                }
                return accepted;
            }

            @Override
            public synchronized void reset() {
                for (Switch filter : filters) {
                    filter.reset();
                }
            }
        };
    }

    public static <T> Switch<T> time(long time, TimeUnit unit) {
        return CappedOperation.time(Clock.REAL_CLOCK, time, unit);
    }

    public static <T> Switch<T> time(final Clock clock, long time, TimeUnit unit) {
        final long timeMillis = unit.toMillis(time);
        return new Switch<T>(){
            private long lastSeen;

            @Override
            public boolean accept(T item) {
                return clock.currentTimeMillis() - this.lastSeen >= timeMillis;
            }

            @Override
            public void reset() {
                this.lastSeen = clock.currentTimeMillis();
            }
        };
    }

    public static <T> Switch<T> count(final long maxCount) {
        return new Switch<T>(){
            private long count;

            @Override
            public boolean accept(T item) {
                return ++this.count >= maxCount;
            }

            @Override
            public void reset() {
                this.count = 0L;
            }
        };
    }

    public static <T> Switch<T> differentItems() {
        return new Switch<T>(){
            private T lastSeenItem;

            @Override
            public boolean accept(T item) {
                boolean accepted = this.lastSeenItem == null || !this.lastSeenItem.equals(item);
                this.lastSeenItem = item;
                return accepted;
            }

            @Override
            public void reset() {
            }
        };
    }

    public static <T> Switch<T> differentItemClasses() {
        return new Switch<T>(){
            private Class lastSeenItemClass;

            @Override
            public boolean accept(T item) {
                boolean accepted = this.lastSeenItemClass == null || !this.lastSeenItemClass.equals(item.getClass());
                this.lastSeenItemClass = item.getClass();
                return accepted;
            }

            @Override
            public void reset() {
            }
        };
    }

    public static interface Switch<T>
    extends Predicate<T> {
        public void reset();
    }
}

