/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class DumpStoreChain<RECORD extends AbstractBaseRecord> {
    private static final String REVERSE = "reverse";
    private static final String NODE = "node";
    private static final String FIRST = "first";
    private static final String RELS = "relationships";
    private static final String PROPS = "properties";
    private static final String RELSTORE = "neostore.relationshipstore.db";
    private static final String PROPSTORE = "neostore.propertystore.db";
    private static final String NODESTORE = "neostore.nodestore.db";
    long first;

    public static void main(String ... args) throws Exception {
        DumpStoreChain tool;
        Args arguments = new Args(args);
        List<String> orphans = arguments.orphans();
        if (orphans.size() != 1) {
            throw DumpStoreChain.invalidUsage("no store file given");
        }
        File storeFile = new File(orphans.get(0));
        if (storeFile.isDirectory()) {
            DumpStoreChain.verifyFilesExists(new File(storeFile, NODESTORE), new File(storeFile, RELSTORE), new File(storeFile, PROPSTORE));
            tool = DumpStoreChain.chainForNode(arguments);
        } else {
            DumpStoreChain.verifyFilesExists(storeFile);
            if (RELSTORE.equals(storeFile.getName())) {
                tool = DumpStoreChain.relationshipChain(arguments);
            } else if (PROPSTORE.equals(storeFile.getName())) {
                tool = DumpStoreChain.propertyChain(arguments);
            } else {
                throw DumpStoreChain.invalidUsage("not a chain store: " + storeFile.getName());
            }
        }
        tool.dump(storeFile);
    }

    private DumpStoreChain(long first) {
        this.first = first;
    }

    private static StringLogger logger() {
        return Boolean.getBoolean("logger") ? StringLogger.SYSTEM : StringLogger.DEV_NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(File storeFile) {
        RecordStore<RECORD> store = this.store(new StoreFactory(new Config(), new DefaultIdGeneratorFactory(), new DefaultWindowPoolFactory(), new DefaultFileSystemAbstraction(), DumpStoreChain.logger(), null), storeFile);
        try {
            long next = this.first;
            while (next != -1L) {
                RECORD record = store.forceGetRecord(next);
                System.out.println(record);
                next = this.next(record);
            }
        }
        finally {
            store.close();
        }
    }

    abstract long next(RECORD var1);

    abstract RecordStore<RECORD> store(StoreFactory var1, File var2);

    private static DumpStoreChain propertyChain(Args args) {
        boolean reverse = DumpStoreChain.verifyParametersAndCheckReverse(args, FIRST);
        return new DumpPropertyChain(Long.parseLong(args.get(FIRST, null)), reverse);
    }

    private static DumpStoreChain relationshipChain(Args args) {
        boolean reverse = DumpStoreChain.verifyParametersAndCheckReverse(args, FIRST, NODE);
        long node = Long.parseLong(args.get(NODE, null));
        return new DumpRelationshipChain(Long.parseLong(args.get(FIRST, null)), node, reverse);
    }

    private static DumpStoreChain chainForNode(Args args) {
        Set<String> kwArgs = args.asMap().keySet();
        DumpStoreChain.verifyParameters(kwArgs, kwArgs.contains(RELS) ? RELS : PROPS, NODE);
        final long node = Long.parseLong(args.get(NODE, null));
        if (args.getBoolean(RELS, false, true).booleanValue()) {
            return new DumpRelationshipChain(-1L, node, false){

                @Override
                RelationshipStore store(StoreFactory factory, File storeFile) {
                    this.first = DumpStoreChain.nodeRecord(factory, storeFile, node).getNextRel();
                    return super.store(factory, new File(storeFile, DumpStoreChain.RELSTORE));
                }
            };
        }
        if (args.getBoolean(PROPS, false, true).booleanValue()) {
            return new DumpPropertyChain(-1L, false){

                @Override
                PropertyStore store(StoreFactory factory, File storeFile) {
                    this.first = DumpStoreChain.nodeRecord(factory, storeFile, node).getNextProp();
                    return super.store(factory, new File(storeFile, DumpStoreChain.PROPSTORE));
                }
            };
        }
        throw DumpStoreChain.invalidUsage(String.format("Must be either -%s or -%s", RELS, PROPS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeRecord nodeRecord(StoreFactory factory, File storeDir, long id) {
        NodeStore store = factory.newNodeStore(new File(storeDir, NODESTORE));
        try {
            NodeRecord nodeRecord = store.forceGetRecord(id);
            return nodeRecord;
        }
        finally {
            store.close();
        }
    }

    private static void verifyFilesExists(File ... files) {
        for (File file : files) {
            if (file.isFile()) continue;
            throw DumpStoreChain.invalidUsage(file + " does not exist");
        }
    }

    private static boolean verifyParametersAndCheckReverse(Args args, String ... parameters) {
        Set<String> kwArgs = args.asMap().keySet();
        if (kwArgs.contains(REVERSE)) {
            parameters = Arrays.copyOf(parameters, parameters.length + 1);
            parameters[parameters.length - 1] = REVERSE;
        }
        DumpStoreChain.verifyParameters(kwArgs, parameters);
        return args.getBoolean(REVERSE, false, true);
    }

    private static void verifyParameters(Set<String> args, String ... parameters) {
        if (args.size() != parameters.length) {
            throw DumpStoreChain.invalidUsage("accepted/required parameters: " + Arrays.toString(parameters));
        }
        for (String parameter : parameters) {
            if (args.contains(parameter)) continue;
            throw DumpStoreChain.invalidUsage("accepted/required parameters: " + Arrays.toString(parameters));
        }
    }

    private static Error invalidUsage(String message) {
        System.err.println("invalid usage: " + message);
        System.exit(1);
        return null;
    }

    private static class DumpRelationshipChain
    extends DumpStoreChain<RelationshipRecord> {
        private final long node;
        private final boolean reverse;

        DumpRelationshipChain(long first, long node, boolean reverse) {
            super(first);
            this.node = node;
            this.reverse = reverse;
        }

        RelationshipStore store(StoreFactory factory, File storeFile) {
            return factory.newRelationshipStore(storeFile);
        }

        @Override
        long next(RelationshipRecord record) {
            if (record.getFirstNode() == this.node) {
                return this.reverse ? record.getFirstPrevRel() : record.getFirstNextRel();
            }
            if (record.getSecondNode() == this.node) {
                return this.reverse ? record.getSecondPrevRel() : record.getSecondNextRel();
            }
            return -1L;
        }
    }

    private static class DumpPropertyChain
    extends DumpStoreChain<PropertyRecord> {
        private final boolean reverse;

        DumpPropertyChain(long first, boolean reverse) {
            super(first);
            this.reverse = reverse;
        }

        PropertyStore store(StoreFactory factory, File storeFile) {
            return factory.newPropertyStore(storeFile);
        }

        @Override
        long next(PropertyRecord record) {
            return this.reverse ? record.getPrevProp() : record.getNextProp();
        }
    }
}

