/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.TransactionManager;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.tooling.Clock;

public class DatabaseAvailability
implements Lifecycle,
AvailabilityGuard.AvailabilityRequirement {
    private InternalAbstractGraphDatabase internalAbstractGraphDatabase;
    private TransactionManager txManager;
    private AvailabilityGuard availabilityGuard;

    public DatabaseAvailability(TransactionManager txManager, AvailabilityGuard availabilityGuard) {
        this.txManager = txManager;
        this.availabilityGuard = availabilityGuard;
        this.internalAbstractGraphDatabase = this.internalAbstractGraphDatabase;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.availabilityGuard.grant(this);
    }

    @Override
    public void stop() throws Throwable {
        this.availabilityGuard.deny(this);
        if (this.txManager instanceof TxManager) {
            long start = Clock.REAL_CLOCK.currentTimeMillis();
            TxManager realTxManager = (TxManager)this.txManager;
            while (realTxManager.getActiveTxCount() > 0 && Clock.REAL_CLOCK.currentTimeMillis() < start + 20000L) {
                Thread.yield();
            }
        }
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName();
    }
}

