/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.ClosableIterator;
import org.neo4j.helpers.collection.LinesOfFileIterator;

public abstract class IteratorUtil {
    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        T result;
        T t = result = iterator.hasNext() ? (T)iterator.next() : null;
        if (iterator.hasNext()) {
            throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
        }
        return result;
    }

    public static <T> T single(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.singleOrNull(iterator));
    }

    public static <T> T fromEnd(Iterator<T> iterator, int n) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.fromEndOrNull(iterator, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        while (first.hasNext() && other.hasNext()) {
            if (first.next().equals(other.next())) continue;
            return false;
        }
        return first.hasNext() == other.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return IteratorUtil.firstOrNull(iterable.iterator());
    }

    public static <T> T first(Iterable<T> iterable) {
        return IteratorUtil.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return IteratorUtil.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return IteratorUtil.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return IteratorUtil.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return IteratorUtil.single(iterable.iterator());
    }

    public static <T> T fromEndOrNull(Iterable<T> iterable, int countFromEnd) {
        return IteratorUtil.fromEndOrNull(iterable.iterator(), countFromEnd);
    }

    public static <T> T fromEnd(Iterable<T> iterable, int n) {
        return IteratorUtil.fromEnd(iterable.iterator(), n);
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollection(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return IteratorUtil.loop(iterator);
    }

    public static <T> int count(Iterator<T> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static <T> int count(Iterable<T> iterable) {
        return IteratorUtil.count(iterable.iterator());
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        IteratorUtil.addToCollection(iterable, list);
        return list;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new HashSet());
    }

    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static ClosableIterable<String> asIterable(final File file) {
        return new ClosableIterable<String>(){
            private ClosableIterator<String> mostRecentIterator;

            @Override
            public Iterator<String> iterator() {
                try {
                    if (this.mostRecentIterator != null) {
                        this.mostRecentIterator.close();
                    }
                    this.mostRecentIterator = IteratorUtil.asIterator(file);
                    return this.mostRecentIterator;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                if (this.mostRecentIterator != null) {
                    this.mostRecentIterator.close();
                }
            }
        };
    }

    public static ClosableIterator<String> asIterator(File file, String encoding) throws IOException {
        return new LinesOfFileIterator(file, encoding);
    }

    public static ClosableIterator<String> asIterator(File file) throws IOException {
        return new LinesOfFileIterator(file);
    }

    public static <T> void streamToFile(Iterable<T> iterable, File file, String encoding) throws IOException {
        IteratorUtil.streamToFile(iterable.iterator(), file, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void streamToFile(Iterator<T> iterator, File file, String encoding) throws IOException {
        if (file.exists()) {
            throw new IOException("File '" + file + "' already exists");
        }
        PrintStream out = null;
        try {
            out = new PrintStream(file, encoding);
            while (iterator.hasNext()) {
                out.println(iterator.next().toString());
            }
        }
        catch (Throwable throwable) {
            IteratorUtil.safeClose(out);
            throw throwable;
        }
        IteratorUtil.safeClose(out);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

