/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.Abstract64BitRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class PropertyRecord
extends Abstract64BitRecord {
    private PropertyType type;
    private int keyIndexId = Record.NO_NEXT_BLOCK.intValue();
    private long propBlock = Record.NO_NEXT_BLOCK.intValue();
    private long prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
    private long nextProp = Record.NO_NEXT_PROPERTY.intValue();
    private List<DynamicRecord> valueRecords = new ArrayList<DynamicRecord>();
    private boolean isLight = false;
    private long nodeRelId = -1L;
    private boolean nodeIdSet = false;
    private boolean isChanged = false;

    public PropertyRecord(long id) {
        super(id);
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public void setNodeId(long nodeId) {
        this.nodeIdSet = true;
        this.nodeRelId = nodeId;
    }

    public void setRelId(long relId) {
        this.nodeIdSet = false;
        this.nodeRelId = relId;
    }

    public long getNodeId() {
        if (this.nodeIdSet) {
            return this.nodeRelId;
        }
        return -1L;
    }

    public long getRelId() {
        if (!this.nodeIdSet) {
            return this.nodeRelId;
        }
        return -1L;
    }

    void setIsLight(boolean status) {
        this.isLight = status;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public Collection<DynamicRecord> getValueRecords() {
        assert (!this.isLight);
        return this.valueRecords;
    }

    public void addValueRecord(DynamicRecord record) {
        assert (!this.isLight);
        this.valueRecords.add(record);
    }

    public PropertyType getType() {
        return this.type;
    }

    public int getKeyIndexId() {
        return this.keyIndexId;
    }

    public void setKeyIndexId(int keyId) {
        this.keyIndexId = keyId;
    }

    public long getPropBlock() {
        return this.propBlock;
    }

    public void setPropBlock(long propBlock) {
        this.propBlock = propBlock;
    }

    public long getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(long prevProp) {
        this.prevProp = prevProp;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PropertyRecord[").append(this.getId()).append(",").append(this.inUse()).append(",").append((Object)this.type).append(",").append(this.keyIndexId).append(",").append(this.propBlock).append(",").append(this.prevProp).append(",").append(this.nextProp);
        buf.append(", Value[");
        for (DynamicRecord record : this.valueRecords) {
            buf.append(record);
        }
        buf.append("]]");
        return buf.toString();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged() {
        this.isChanged = true;
    }
}

