/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.kernel.Config;

public abstract class FileLock {
    private static FileLock wrapOrNull(final java.nio.channels.FileLock lock) {
        if (lock == null) {
            return null;
        }
        return new FileLock(){

            @Override
            public void release() throws IOException {
                lock.release();
            }
        };
    }

    public static FileLock getOsSpecificFileLock(String fileName, FileChannel channel) throws IOException {
        if (Config.osIsWindows()) {
            if (fileName.endsWith("neostore")) {
                return FileLock.getWindowsFileLock(new File(fileName).getParentFile());
            }
            return new PlaceboFileLock();
        }
        return FileLock.wrapOrNull(channel.tryLock());
    }

    private static FileLock getWindowsFileLock(File storeDir) throws IOException {
        File lockFile = new File(storeDir, "lock");
        if (!lockFile.exists() && !lockFile.createNewFile()) {
            throw new IOException("Couldn't create lock file " + lockFile.getAbsolutePath());
        }
        FileChannel fileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
        java.nio.channels.FileLock fileChannelLock = null;
        try {
            fileChannelLock = fileChannel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            // empty catch block
        }
        if (fileChannelLock == null) {
            fileChannel.close();
            return null;
        }
        return new WindowsFileLock(lockFile, fileChannel, fileChannelLock);
    }

    public abstract void release() throws IOException;

    private static class WindowsFileLock
    extends FileLock {
        private final File lockFile;
        private final FileChannel fileChannel;
        private final java.nio.channels.FileLock fileChannelLock;

        public WindowsFileLock(File lockFile, FileChannel fileChannel, java.nio.channels.FileLock lock) throws IOException {
            this.lockFile = lockFile;
            this.fileChannel = fileChannel;
            this.fileChannelLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws IOException {
            try {
                this.fileChannelLock.release();
            }
            finally {
                try {
                    this.fileChannel.close();
                }
                finally {
                    if (!this.lockFile.delete()) {
                        throw new IOException("Couldn't delete lock file " + this.lockFile.getAbsolutePath());
                    }
                }
            }
        }
    }

    private static class PlaceboFileLock
    extends FileLock {
        private PlaceboFileLock() {
        }

        @Override
        public void release() throws IOException {
        }
    }
}

