/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashSet;

public class IntArray {
    public static final IntArray EMPTY = new IntArray(){

        @Override
        public int length() {
            return 0;
        }
    };
    private int[] rels;
    private int arrayCount = 0;

    public IntArray() {
        this.rels = new int[2];
    }

    public IntArray(int initialCapacity) {
        this.rels = new int[initialCapacity];
    }

    public IntArray(int[] array) {
        this.rels = array;
        this.arrayCount = array.length;
    }

    public void add(int id) {
        if (this.arrayCount == this.rels.length) {
            int[] newRels = new int[this.rels.length * 2];
            System.arraycopy(this.rels, 0, newRels, 0, this.rels.length);
            this.rels = newRels;
        }
        this.rels[this.arrayCount++] = id;
    }

    public void addAll(IntArray array) {
        if (array == null) {
            return;
        }
        if (array.length() + this.arrayCount > this.rels.length) {
            int newSize;
            for (newSize = this.rels.length * 2; array.length() + this.arrayCount > newSize; newSize *= 2) {
            }
            int[] newRels = new int[newSize];
            System.arraycopy(this.rels, 0, newRels, 0, this.arrayCount);
            this.rels = newRels;
        }
        System.arraycopy(array.getArray(), 0, this.rels, this.arrayCount, array.length());
        this.arrayCount += array.length();
    }

    public int length() {
        return this.arrayCount;
    }

    public int[] getArray() {
        return this.rels;
    }

    public int get(int i) {
        assert (i >= 0 && i < this.arrayCount);
        return this.rels[i];
    }

    public static IntArray composeNew(IntArray src, IntArray add, IntArray remove) {
        int value;
        int i;
        if (remove == null) {
            if (src == null) {
                return add;
            }
            if (add != null) {
                IntArray newArray = new IntArray(add.length() + src.length());
                newArray.addAll(src);
                newArray.addAll(add);
                return newArray;
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        int newLength = 0;
        if (add != null) {
            newLength += add.length();
        }
        if (src != null) {
            newLength += src.length();
        }
        IntArray newArray = new IntArray(newLength);
        HashSet<Integer> set = new HashSet<Integer>(remove.length() + 1, 1.0f);
        for (i = 0; i < remove.length(); ++i) {
            set.add(remove.get(i));
        }
        newArray.addAll(src);
        for (i = 0; i < newArray.length(); ++i) {
            value = newArray.get(i);
            if (!set.contains(value)) continue;
            boolean swapSuccessful = false;
            for (int j = newArray.length() - 1; j >= i + 1; --j) {
                int backValue = newArray.get(j);
                --newArray.arrayCount;
                if (set.contains(backValue)) continue;
                newArray.getArray()[i] = backValue;
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            --newArray.arrayCount;
        }
        if (add != null) {
            for (i = 0; i < add.length(); ++i) {
                value = add.get(i);
                if (set.contains(value)) continue;
                newArray.add(value);
            }
        }
        return newArray;
    }
}

