/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

class MemoryMappedLogBuffer
implements LogBuffer {
    private static final int MAPPED_SIZE = 0x200000;
    private final FileChannel fileChannel;
    private MappedByteBuffer mappedBuffer = null;
    private long mappedStartPosition;
    private final ByteBuffer fallbackBuffer;
    private int mapFail = -1;

    MemoryMappedLogBuffer(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this.mappedStartPosition = fileChannel.position();
        this.getNewMappedBuffer();
        this.fallbackBuffer = ByteBuffer.allocateDirect(713);
    }

    MappedByteBuffer getMappedBuffer() {
        return this.mappedBuffer;
    }

    private void getNewMappedBuffer() {
        try {
            if (this.mappedBuffer != null) {
                this.mappedStartPosition += (long)this.mappedBuffer.position();
                this.mappedBuffer.force();
                this.mappedBuffer = null;
            }
            if (this.mapFail > 1000) {
                this.mapFail = -1;
            }
            if (this.mapFail > 0) {
                ++this.mapFail;
                return;
            }
            this.mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, this.mappedStartPosition, 0x200000L);
        }
        catch (Throwable t) {
            this.mapFail = 1;
            t.printStackTrace();
        }
    }

    @Override
    public LogBuffer put(byte b) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 1) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.put(b);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                ++this.mappedStartPosition;
                return this;
            }
        }
        this.mappedBuffer.put(b);
        return this;
    }

    @Override
    public LogBuffer putInt(int i) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 4) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putInt(i);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 4L;
                return this;
            }
        }
        this.mappedBuffer.putInt(i);
        return this;
    }

    @Override
    public LogBuffer putLong(long l) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 8) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putLong(l);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 8L;
                return this;
            }
        }
        this.mappedBuffer.putLong(l);
        return this;
    }

    @Override
    public LogBuffer putFloat(float f) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 4) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putFloat(f);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 4L;
                return this;
            }
        }
        this.mappedBuffer.putFloat(f);
        return this;
    }

    @Override
    public LogBuffer putDouble(double d) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 8) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putDouble(d);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 8L;
                return this;
            }
        }
        this.mappedBuffer.putDouble(d);
        return this;
    }

    @Override
    public LogBuffer put(byte[] bytes) throws IOException {
        this.put(bytes, 0);
        return this;
    }

    private void put(byte[] bytes, int offset) throws IOException {
        int bytesToWrite = bytes.length - offset;
        if (bytesToWrite > 0x200000) {
            bytesToWrite = 0x200000;
        }
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < bytesToWrite) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                bytesToWrite = bytes.length - offset;
                ByteBuffer buf = ByteBuffer.wrap(bytes);
                buf.position(offset);
                int count = this.fileChannel.write(buf, this.mappedStartPosition);
                if (count != bytesToWrite) {
                    throw new UnderlyingStorageException("Failed to write from " + offset + " expected " + bytesToWrite + " but wrote " + count);
                }
                this.mappedStartPosition += (long)bytesToWrite;
                return;
            }
        }
        this.mappedBuffer.put(bytes, offset, bytesToWrite);
        if ((offset += bytesToWrite) < bytes.length) {
            this.put(bytes, offset);
        }
    }

    @Override
    public LogBuffer put(char[] chars) throws IOException {
        this.put(chars, 0);
        return this;
    }

    private void put(char[] chars, int offset) throws IOException {
        int charsToWrite = chars.length - offset;
        if (charsToWrite * 2 > 0x200000) {
            charsToWrite = 0x100000;
        }
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < charsToWrite * 2) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                int bytesToWrite = (chars.length - offset) * 2;
                ByteBuffer buf = ByteBuffer.allocate(bytesToWrite);
                buf.asCharBuffer().put(chars, offset, chars.length - offset);
                buf.limit(chars.length * 2);
                int count = this.fileChannel.write(buf, this.mappedStartPosition);
                if (count != bytesToWrite) {
                    throw new UnderlyingStorageException("Failed to write from " + offset + " expected " + bytesToWrite + " but wrote " + count);
                }
                this.mappedStartPosition += (long)bytesToWrite;
                return;
            }
        }
        int oldPos = this.mappedBuffer.position();
        this.mappedBuffer.asCharBuffer().put(chars, offset, charsToWrite);
        this.mappedBuffer.position(oldPos + charsToWrite * 2);
        if ((offset += charsToWrite) < chars.length) {
            this.put(chars, offset);
        }
    }

    void releaseMemoryMapped() {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.force();
            this.mappedBuffer = null;
        }
    }

    @Override
    public void force() throws IOException {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.force();
        }
        this.fileChannel.force(false);
    }

    @Override
    public long getFileChannelPosition() {
        if (this.mappedBuffer != null) {
            return this.mappedStartPosition + (long)this.mappedBuffer.position();
        }
        return this.mappedStartPosition;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

