/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.MappedMemException;
import org.neo4j.kernel.impl.nioneo.store.MappedPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PlainPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

class PersistenceWindowPool {
    private static final int MAX_BRICK_COUNT = 100000;
    private final String storeName;
    private final int blockSize;
    private FileChannel fileChannel;
    private final Map<Integer, PersistenceRow> activeRowWindows = new HashMap<Integer, PersistenceRow>();
    private long availableMem = 0L;
    private long memUsed = 0L;
    private int brickCount = 0;
    private int brickSize = 0;
    private BrickElement[] brickArray = new BrickElement[0];
    private int brickMiss = 0;
    private static Logger log = Logger.getLogger(PersistenceWindowPool.class.getName());
    private static final int REFRESH_BRICK_COUNT = 50000;
    private final FileChannel.MapMode mapMode;
    private int hit = 0;
    private int miss = 0;
    private int switches = 0;
    private int ooe = 0;
    private boolean useMemoryMapped = true;

    PersistenceWindowPool(String storeName, int blockSize, FileChannel fileChannel, long mappedMem, boolean useMemoryMappedBuffers, boolean readOnly) {
        this.storeName = storeName;
        this.blockSize = blockSize;
        this.fileChannel = fileChannel;
        this.availableMem = mappedMem;
        this.useMemoryMapped = useMemoryMappedBuffers;
        this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.setupBricks();
        this.dumpStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistenceWindow acquire(long position, OperationType operationType) {
        LockableWindow window = null;
        boolean readPos = false;
        if (this.brickMiss >= 50000) {
            this.refreshBricks();
        }
        if (this.brickSize > 0) {
            int brickIndex = (int)(position * (long)this.blockSize / (long)this.brickSize);
            if (brickIndex < this.brickArray.length) {
                PersistenceWindowPool persistenceWindowPool = this;
                synchronized (persistenceWindowPool) {
                    window = this.brickArray[brickIndex].getWindow();
                    if (window != null) {
                        window.mark();
                    }
                }
                this.brickArray[brickIndex].setHit();
            } else {
                this.expandBricks(brickIndex + 1);
                window = this.brickArray[brickIndex].getWindow();
            }
        }
        if (window == null) {
            PersistenceWindowPool persistenceWindowPool = this;
            synchronized (persistenceWindowPool) {
                ++this.miss;
                ++this.brickMiss;
                PersistenceRow dpw = this.activeRowWindows.get((int)position);
                if (dpw == null) {
                    dpw = new PersistenceRow(position, this.blockSize, this.fileChannel);
                }
                if (operationType == OperationType.READ) {
                    readPos = true;
                }
                window = dpw;
                this.activeRowWindows.put((int)position, dpw);
                window.mark();
            }
        } else {
            ++this.hit;
        }
        window.lock();
        if (readPos) {
            ((PersistenceRow)window).readPosition();
        }
        window.setOperationType(operationType);
        return window;
    }

    void dumpStatistics() {
        log.finest(this.storeName + " hit=" + this.hit + " miss=" + this.miss + " switches=" + this.switches + " ooe=" + this.ooe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(PersistenceWindow window) {
        if (window instanceof PersistenceRow) {
            PersistenceRow dpw = (PersistenceRow)window;
            dpw.writeOut();
            PersistenceWindowPool persistenceWindowPool = this;
            synchronized (persistenceWindowPool) {
                if (dpw.getWaitingThreadsCount() == 0 && !dpw.isMarked()) {
                    int key = (int)dpw.position();
                    this.activeRowWindows.remove(key);
                }
            }
            dpw.unLock();
        } else {
            ((LockableWindow)window).unLock();
        }
    }

    synchronized void close() {
        this.flushAll();
        for (BrickElement element : this.brickArray) {
            if (element.getWindow() == null) continue;
            element.getWindow().close();
            element.setWindow(null);
        }
        this.fileChannel = null;
        this.activeRowWindows.clear();
        this.dumpStatistics();
    }

    void flushAll() {
        for (BrickElement element : this.brickArray) {
            LockableWindow window = element.getWindow();
            if (window == null) continue;
            window.force();
        }
        try {
            this.fileChannel.force(false);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush file channel " + this.storeName, e);
        }
    }

    private void setupBricks() {
        long fileSize = -1L;
        try {
            fileSize = this.fileChannel.size();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to get file size for " + this.storeName, e);
        }
        if (this.blockSize == 0) {
            return;
        }
        if (this.availableMem > 0L && this.availableMem < (long)this.blockSize * 10L) {
            this.logWarn("Unable to use " + this.availableMem + "b as memory mapped windows, need at least " + this.blockSize * 10 + "b (block size * 10)");
            this.logWarn("Memory mapped windows have been turned off");
            this.availableMem = 0L;
            this.brickCount = 0;
            this.brickSize = 0;
            return;
        }
        if (this.availableMem > 0L && fileSize > 0L) {
            double ratio = ((double)this.availableMem + 0.0) / (double)fileSize;
            if (ratio >= 1.0) {
                this.brickSize = (int)(this.availableMem / 1000L);
                if (this.brickSize < 0) {
                    this.brickSize = Integer.MAX_VALUE;
                }
                this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                this.brickCount = (int)(fileSize / (long)this.brickSize);
            } else {
                this.brickCount = (int)(1000.0 / ratio);
                if (this.brickCount > 100000) {
                    this.brickCount = 100000;
                }
                if (fileSize / (long)this.brickCount > this.availableMem) {
                    this.logWarn("Unable to use " + this.availableMem / 1024L + "kb as memory mapped windows, need at least " + fileSize / (long)this.brickCount / 1024L + "kb");
                    this.logWarn("Memory mapped windows have been turned off");
                    this.availableMem = 0L;
                    this.brickCount = 0;
                    this.brickSize = 0;
                    return;
                }
                this.brickSize = (int)(fileSize / (long)this.brickCount);
                if (this.brickSize < 0) {
                    this.brickSize = Integer.MAX_VALUE;
                    this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                    this.brickCount = (int)(fileSize / (long)this.brickSize);
                } else {
                    this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                }
                assert (this.brickSize > this.blockSize);
            }
        } else if (this.availableMem > 0L) {
            this.brickSize = (int)(this.availableMem / 100L);
            if (this.brickSize < 0) {
                this.brickSize = Integer.MAX_VALUE;
            }
            this.brickSize = this.brickSize / this.blockSize * this.blockSize;
        }
        this.brickArray = new BrickElement[this.brickCount];
        for (int i = 0; i < this.brickCount; ++i) {
            BrickElement element;
            this.brickArray[i] = element = new BrickElement(i);
        }
    }

    private synchronized void freeWindows(int nr) {
        int i;
        if (this.brickSize <= 0) {
            return;
        }
        ArrayList<BrickElement> mappedBricks = new ArrayList<BrickElement>();
        for (i = 0; i < this.brickCount; ++i) {
            BrickElement be = this.brickArray[i];
            if (be.getWindow() == null) continue;
            mappedBricks.add(be);
        }
        Collections.sort(mappedBricks, new BrickSorter());
        for (i = 0; i < nr && i < mappedBricks.size(); ++i) {
            BrickElement mappedBrick = (BrickElement)mappedBricks.get(i);
            LockableWindow window = mappedBrick.getWindow();
            if (window.getWaitingThreadsCount() != 0 || window.isMarked()) continue;
            if (window instanceof MappedPersistenceWindow) {
                ((MappedPersistenceWindow)window).unmap();
            } else if (window instanceof PlainPersistenceWindow) {
                ((PlainPersistenceWindow)window).writeOut();
            }
            mappedBrick.setWindow(null);
            this.memUsed -= (long)this.brickSize;
        }
    }

    private synchronized void refreshBricks() {
        if (this.brickMiss < 50000) {
            return;
        }
        this.brickMiss = 0;
        if (this.brickSize <= 0) {
            return;
        }
        ArrayList<BrickElement> nonMappedBricks = new ArrayList<BrickElement>();
        ArrayList<BrickElement> mappedBricks = new ArrayList<BrickElement>();
        for (int i = 0; i < this.brickCount; ++i) {
            BrickElement be = this.brickArray[i];
            if (be.getWindow() != null) {
                mappedBricks.add(be);
            } else {
                nonMappedBricks.add(be);
            }
            be.refresh();
        }
        Collections.sort(nonMappedBricks, new BrickSorter());
        Collections.sort(mappedBricks, new BrickSorter());
        int mappedIndex = 0;
        int nonMappedIndex = nonMappedBricks.size() - 1;
        while (this.memUsed + (long)this.brickSize <= this.availableMem && nonMappedIndex >= 0) {
            BrickElement nonMappedBrick;
            if ((nonMappedBrick = (BrickElement)nonMappedBricks.get(nonMappedIndex--)).getHit() == 0) {
                return;
            }
            try {
                nonMappedBrick.setWindow(this.allocateNewWindow(nonMappedBrick.index()));
                this.memUsed += (long)this.brickSize;
            }
            catch (MappedMemException e) {
                e.printStackTrace();
                ++this.ooe;
                this.logWarn("Unable to memory map");
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                ++this.ooe;
                this.logWarn("Unable to allocate direct buffer");
            }
        }
        while (nonMappedIndex >= 0 && mappedIndex < mappedBricks.size()) {
            BrickElement mappedBrick = (BrickElement)mappedBricks.get(mappedIndex++);
            BrickElement nonMappedBrick = (BrickElement)nonMappedBricks.get(nonMappedIndex--);
            if (mappedBrick.getHit() >= nonMappedBrick.getHit()) break;
            LockableWindow window = mappedBrick.getWindow();
            if (window.getWaitingThreadsCount() != 0 || window.isMarked()) continue;
            if (window instanceof MappedPersistenceWindow) {
                ((MappedPersistenceWindow)window).unmap();
            } else if (window instanceof PlainPersistenceWindow) {
                ((PlainPersistenceWindow)window).writeOut();
            }
            mappedBrick.setWindow(null);
            this.memUsed -= (long)this.brickSize;
            try {
                nonMappedBrick.setWindow(this.allocateNewWindow(nonMappedBrick.index()));
                this.memUsed += (long)this.brickSize;
                ++this.switches;
            }
            catch (MappedMemException e) {
                ++this.ooe;
                this.logWarn("Unable to memory map");
            }
            catch (OutOfMemoryError e) {
                ++this.ooe;
                this.logWarn("Unable to allocate direct buffer");
            }
        }
    }

    private synchronized void expandBricks(int newBrickCount) {
        if (newBrickCount > this.brickCount) {
            BrickElement[] tmpArray = new BrickElement[newBrickCount];
            System.arraycopy(this.brickArray, 0, tmpArray, 0, this.brickArray.length);
            if (this.memUsed + (long)this.brickSize >= this.availableMem) {
                this.freeWindows(1);
            }
            for (int i = this.brickArray.length; i < tmpArray.length; ++i) {
                BrickElement be;
                tmpArray[i] = be = new BrickElement(i);
                if (this.memUsed + (long)this.brickSize > this.availableMem) continue;
                try {
                    be.setWindow(this.allocateNewWindow(i));
                    this.memUsed += (long)this.brickSize;
                    continue;
                }
                catch (MappedMemException e) {
                    ++this.ooe;
                    this.logWarn("Unable to memory map");
                    continue;
                }
                catch (OutOfMemoryError e) {
                    ++this.ooe;
                    this.logWarn("Unable to allocate direct buffer");
                }
            }
            this.brickArray = tmpArray;
            this.brickCount = tmpArray.length;
        }
    }

    private LockableWindow allocateNewWindow(long brick) {
        if (this.useMemoryMapped) {
            return new MappedPersistenceWindow(brick * (long)this.brickSize / (long)this.blockSize, this.blockSize, this.brickSize, this.fileChannel, this.mapMode);
        }
        PlainPersistenceWindow dpw = new PlainPersistenceWindow(brick * (long)this.brickSize / (long)this.blockSize, this.blockSize, this.brickSize, this.fileChannel);
        dpw.readPosition();
        return dpw;
    }

    private void dumpStatus() {
        try {
            log.fine("[" + this.storeName + "] brickCount=" + this.brickCount + " brickSize=" + this.brickSize + "b mappedMem=" + this.availableMem + "b (storeSize=" + this.fileChannel.size() + "b)");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to get file size for " + this.storeName, e);
        }
    }

    private void logWarn(String logMessage) {
        log.warning("[" + this.storeName + "] " + logMessage);
    }

    WindowPoolStats getStats() {
        return new WindowPoolStats(this.storeName, this.availableMem, this.memUsed, this.brickCount, this.brickSize, this.hit, this.miss, this.ooe);
    }

    static class BrickSorter
    implements Comparator<BrickElement>,
    Serializable {
        BrickSorter() {
        }

        @Override
        public int compare(BrickElement o1, BrickElement o2) {
            return o1.getHit() - o2.getHit();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof BrickSorter;
        }

        public int hashCode() {
            return 7371;
        }
    }

    private static class BrickElement {
        private int index;
        private int hitCount;
        private LockableWindow window = null;

        BrickElement(int index) {
            this.index = index;
        }

        void setWindow(LockableWindow window) {
            this.window = window;
        }

        LockableWindow getWindow() {
            return this.window;
        }

        int index() {
            return this.index;
        }

        void setHit() {
            this.hitCount += 10;
            if (this.hitCount < 0) {
                this.hitCount -= 10;
            }
        }

        int getHit() {
            return this.hitCount;
        }

        void refresh() {
            this.hitCount = this.window == null ? (int)((double)this.hitCount / 1.25) : (int)((double)this.hitCount / 1.15);
        }

        public String toString() {
            return "" + this.hitCount + (this.window == null ? "x" : "o");
        }
    }
}

