/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public abstract class NestingIterator<T, U>
extends PrefetchingIterator<T> {
    private Iterator<U> source;
    private Iterator<T> currentNestedIterator;
    private U currentSurfaceItem;

    public NestingIterator(Iterator<U> source) {
        this.source = source;
    }

    protected abstract Iterator<T> createNestedIterator(U var1);

    public U getCurrentSurfaceItem() {
        if (this.currentSurfaceItem == null) {
            throw new IllegalStateException("Has no surface item right now, you must do at least one next() first");
        }
        return this.currentSurfaceItem;
    }

    @Override
    protected T fetchNextOrNull() {
        if (this.currentNestedIterator == null || !this.currentNestedIterator.hasNext()) {
            while (this.source.hasNext()) {
                this.currentSurfaceItem = this.source.next();
                this.currentNestedIterator = this.createNestedIterator(this.currentSurfaceItem);
                if (!this.currentNestedIterator.hasNext()) continue;
            }
        }
        return this.currentNestedIterator != null && this.currentNestedIterator.hasNext() ? (T)this.currentNestedIterator.next() : null;
    }
}

