/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.StringTokenizer;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.util.StringLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XaDataSource {
    private byte[] branchId = null;
    private String name = null;
    private final StringLogger msgLog;

    public XaDataSource(Map<?, ?> params) throws InstantiationException {
        String storeDir = (String)params.get("store_dir");
        this.msgLog = StringLogger.getLogger(storeDir + "/messages.log");
    }

    public abstract XaConnection getXaConnection();

    public abstract void close();

    public void setBranchId(byte[] branchId) {
        this.branchId = branchId;
    }

    public byte[] getBranchId() {
        return this.branchId;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public String getFileName(long version) {
        throw new UnsupportedOperationException();
    }

    public long getRandomIdentifier() {
        throw new UnsupportedOperationException();
    }

    public long getCurrentLogVersion() {
        throw new UnsupportedOperationException();
    }

    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rotateLogicalLog() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean hasLogicalLog(long version) {
        throw new UnsupportedOperationException();
    }

    public long getLogicalLogLength(long version) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteLogicalLog(long version) {
        throw new UnsupportedOperationException();
    }

    public void keepLogicalLogs(boolean keepLogs) {
        throw new UnsupportedOperationException();
    }

    public boolean isLogicalLogKept() {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void makeBackupSlave() {
        throw new UnsupportedOperationException();
    }

    public void setAutoRotate(boolean rotate) {
        throw new UnsupportedOperationException();
    }

    public void setLogicalLogTargetSize(long size) {
        throw new UnsupportedOperationException();
    }

    protected boolean shouldKeepLog(String config, String resourceName) {
        if (config != null) {
            if (config.equals(Boolean.TRUE.toString())) {
                return true;
            }
            StringTokenizer tok = new StringTokenizer(config, ",");
            while (tok.hasMoreTokens()) {
                String element = tok.nextToken().trim();
                if (!resourceName.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public ReadableByteChannel getCommittedTransaction(long txId) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void applyCommittedTransaction(long txId, ReadableByteChannel transaction) throws IOException {
        this.getXaContainer().getResourceManager().applyCommittedTransaction(transaction, txId);
    }

    public long applyPreparedTransaction(ReadableByteChannel transaction) throws IOException {
        return this.getXaContainer().getResourceManager().applyPreparedTransaction(transaction);
    }

    public long getLastCommittedTxId() {
        throw new UnsupportedOperationException();
    }

    public XaContainer getXaContainer() {
        throw new UnsupportedOperationException();
    }

    public int getMasterForCommittedTx(long txId) throws IOException {
        throw new UnsupportedOperationException();
    }
}

