/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class LogIoUtils {
    public static LogEntry readEntry(ByteBuffer buffer, ReadableByteChannel channel, XaCommandFactory cf) throws IOException {
        try {
            byte entry = LogIoUtils.readNextByte(buffer, channel);
            switch (entry) {
                case 1: {
                    return LogIoUtils.readTxStartEntry(buffer, channel);
                }
                case 2: {
                    return LogIoUtils.readTxPrepareEntry(buffer, channel);
                }
                case 5: {
                    return LogIoUtils.readTxOnePhaseCommitEntry(buffer, channel);
                }
                case 6: {
                    return LogIoUtils.readTxTwoPhaseCommitEntry(buffer, channel);
                }
                case 3: {
                    return LogIoUtils.readTxCommandEntry(buffer, channel, cf);
                }
                case 4: {
                    return LogIoUtils.readTxDoneEntry(buffer, channel);
                }
                case 0: {
                    return null;
                }
            }
            throw new IOException("Unknown entry[" + entry + "]");
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private static LogEntry.Start readTxStartEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte globalIdLength = LogIoUtils.readNextByte(buf, channel);
        byte branchIdLength = LogIoUtils.readNextByte(buf, channel);
        byte[] globalId = new byte[globalIdLength];
        LogIoUtils.readIntoBufferAndFlip(ByteBuffer.wrap(globalId), channel, globalIdLength);
        byte[] branchId = new byte[branchIdLength];
        LogIoUtils.readIntoBufferAndFlip(ByteBuffer.wrap(branchId), channel, branchIdLength);
        int identifier = LogIoUtils.readNextInt(buf, channel);
        int formatId = LogIoUtils.readNextInt(buf, channel);
        XidImpl xid = new XidImpl(globalId, branchId, formatId);
        return new LogEntry.Start(xid, identifier, -1L);
    }

    private static LogEntry.Prepare readTxPrepareEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Prepare(LogIoUtils.readNextInt(buf, channel));
    }

    private static LogEntry.OnePhaseCommit readTxOnePhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.OnePhaseCommit(LogIoUtils.readNextInt(buf, channel), LogIoUtils.readNextLong(buf, channel), LogIoUtils.readNextInt(buf, channel));
    }

    private static LogEntry.Done readTxDoneEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Done(LogIoUtils.readNextInt(buf, channel));
    }

    private static LogEntry.TwoPhaseCommit readTxTwoPhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.TwoPhaseCommit(LogIoUtils.readNextInt(buf, channel), LogIoUtils.readNextLong(buf, channel), LogIoUtils.readNextInt(buf, channel));
    }

    private static LogEntry.Command readTxCommandEntry(ByteBuffer buf, ReadableByteChannel channel, XaCommandFactory cf) throws IOException, ReadPastEndException {
        int identifier = LogIoUtils.readNextInt(buf, channel);
        XaCommand command = cf.readCommand(channel, buf);
        if (command == null) {
            return null;
        }
        return new LogEntry.Command(identifier, command);
    }

    public static void writeLogEntry(LogEntry entry, LogBuffer buffer) throws IOException {
        if (entry instanceof LogEntry.Command) {
            buffer.put((byte)3).putInt(entry.getIdentifier());
            XaCommand command = ((LogEntry.Command)entry).getXaCommand();
            command.writeToFile(buffer);
        } else if (entry instanceof LogEntry.Start) {
            LogEntry.Start start = (LogEntry.Start)entry;
            Xid xid = start.getXid();
            byte[] globalId = xid.getGlobalTransactionId();
            byte[] branchId = xid.getBranchQualifier();
            int formatId = xid.getFormatId();
            int identifier = start.getIdentifier();
            buffer.put((byte)1).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId).putInt(identifier).putInt(formatId);
        } else if (entry instanceof LogEntry.Done) {
            buffer.put((byte)4).putInt(entry.getIdentifier());
        } else if (entry instanceof LogEntry.OnePhaseCommit) {
            LogEntry.Commit commit = (LogEntry.Commit)entry;
            buffer.put((byte)5).putInt(commit.getIdentifier()).putLong(commit.getTxId()).putInt(commit.getMasterId());
        } else if (entry instanceof LogEntry.Prepare) {
            buffer.put((byte)2).putInt(entry.getIdentifier());
        } else if (entry instanceof LogEntry.TwoPhaseCommit) {
            LogEntry.Commit commit = (LogEntry.Commit)entry;
            buffer.put((byte)6).putInt(commit.getIdentifier()).putLong(commit.getTxId()).putInt(commit.getMasterId());
        }
    }

    private static int readNextInt(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 4).getInt();
    }

    private static long readNextLong(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 8).getLong();
    }

    private static byte readNextByte(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return LogIoUtils.readIntoBufferAndFlip(buf, channel, 1).get();
    }

    private static ByteBuffer readIntoBufferAndFlip(ByteBuffer buf, ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        buf.clear();
        buf.limit(numberOfBytes);
        if (channel.read(buf) != buf.limit()) {
            throw new ReadPastEndException();
        }
        buf.flip();
        return buf;
    }
}

