/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.IntArrayIterator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.RelTypeElement;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeImpl
extends Primitive {
    private volatile ArrayMap<String, IntArray> relationshipMap = null;
    private RelationshipChainPosition relChainPosition = null;

    NodeImpl(int id) {
        super(id);
    }

    NodeImpl(int id, boolean newNode) {
        super(id, newNode);
        if (newNode) {
            this.relationshipMap = new ArrayMap();
            this.relChainPosition = new RelationshipChainPosition(Record.NO_NEXT_RELATIONSHIP.intValue());
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeImpl && ((NodeImpl)obj).id == this.id;
    }

    @Override
    protected void changeProperty(NodeManager nodeManager, int propertyId, Object value) {
        nodeManager.nodeChangeProperty(this, propertyId, value);
    }

    @Override
    protected int addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.nodeAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, int propertyId) {
        nodeManager.nodeRemoveProperty(this, propertyId);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    List<RelTypeElementIterator> getAllRelationships(NodeManager nodeManager) {
        this.ensureRelationshipMapNotNull(nodeManager);
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        ArrayMap<String, IntArray> addMap = null;
        if (hasModifications) {
            addMap = nodeManager.getCowRelationshipAddMap(this);
        }
        for (String type : this.relationshipMap.keySet()) {
            IntArray src = this.relationshipMap.get(type);
            IntArray remove = null;
            IntArray add = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                if (addMap != null) {
                    add = addMap.get(type);
                }
            }
            relTypeList.add(RelTypeElement.create(type, this, src, add, remove));
        }
        if (addMap != null) {
            for (String type : addMap.keySet()) {
                if (this.relationshipMap.get(type) != null) continue;
                IntArray remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                IntArray add = addMap.get(type);
                relTypeList.add(RelTypeElement.create(type, this, null, add, remove));
            }
        }
        return relTypeList;
    }

    List<RelTypeElementIterator> getAllRelationshipsOfType(NodeManager nodeManager, RelationshipType ... types) {
        this.ensureRelationshipMapNotNull(nodeManager);
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        for (RelationshipType type : types) {
            IntArray src = this.relationshipMap.get(type.name());
            IntArray remove = null;
            IntArray add = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, type.name());
                add = nodeManager.getCowRelationshipAddMap(this, type.name());
            }
            relTypeList.add(RelTypeElement.create(type.name(), this, src, add, remove));
        }
        return relTypeList;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager) {
        return new IntArrayIterator(this.getAllRelationships(nodeManager), this, Direction.BOTH, nodeManager, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction dir) {
        return new IntArrayIterator(this.getAllRelationships(nodeManager), this, dir, nodeManager, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type) {
        RelationshipType[] types = new RelationshipType[]{type};
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, types), this, Direction.BOTH, nodeManager, types);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType ... types) {
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, types), this, Direction.BOTH, nodeManager, types);
    }

    public Relationship getSingleRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        IntArrayIterator rels = new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, types), this, dir, nodeManager, types);
        if (!rels.hasNext()) {
            return null;
        }
        Relationship rel = (Relationship)rels.next();
        if (rels.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
        }
        return rel;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, types), this, dir, nodeManager, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager) {
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this, true);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteNode(this);
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
            Object var8_7 = null;
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
            throw throwable;
        }
    }

    public String toString() {
        return "NodeImpl#" + this.getId();
    }

    void addRelationship(NodeManager nodeManager, RelationshipType type, int relId) {
        IntArray relationshipSet = nodeManager.getCowRelationshipAddMap(this, type.name(), true);
        relationshipSet.add(relId);
    }

    void removeRelationship(NodeManager nodeManager, RelationshipType type, int relId) {
        IntArray relationshipSet = nodeManager.getCowRelationshipRemoveMap(this, type.name(), true);
        relationshipSet.add(relId);
    }

    private void ensureRelationshipMapNotNull(NodeManager nodeManager) {
        if (this.relationshipMap == null) {
            this.loadInitialRelationships(nodeManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialRelationships(NodeManager nodeManager) {
        Map<Integer, RelationshipImpl> map = null;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (this.relationshipMap == null) {
                this.relChainPosition = nodeManager.getRelationshipChainPosition(this);
                ArrayMap<String, IntArray> tmpRelMap = new ArrayMap<String, IntArray>();
                map = this.getMoreRelationships(nodeManager, tmpRelMap);
                this.relationshipMap = tmpRelMap;
            }
        }
        if (map != null) {
            nodeManager.putAllInRelCache(map);
        }
    }

    private Map<Integer, RelationshipImpl> getMoreRelationships(NodeManager nodeManager, ArrayMap<String, IntArray> tmpRelMap) {
        if (!this.relChainPosition.hasMore()) {
            return null;
        }
        Pair<ArrayMap<String, IntArray>, Map<Integer, RelationshipImpl>> pair = nodeManager.getMoreRelationships(this);
        ArrayMap<String, IntArray> addMap = pair.first();
        if (addMap.size() == 0) {
            return null;
        }
        for (String type : addMap.keySet()) {
            IntArray addRels = addMap.get(type);
            IntArray srcRels = tmpRelMap.get(type);
            if (srcRels == null) {
                tmpRelMap.put(type, addRels);
                continue;
            }
            srcRels.addAll(addRels);
        }
        return pair.other();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getMoreRelationships(NodeManager nodeManager) {
        Pair<ArrayMap<String, IntArray>, Map<Integer, RelationshipImpl>> pair;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (!this.relChainPosition.hasMore()) {
                return false;
            }
            pair = nodeManager.getMoreRelationships(this);
            ArrayMap<String, IntArray> addMap = pair.first();
            if (addMap.size() == 0) {
                return false;
            }
            for (String type : addMap.keySet()) {
                IntArray addRels = addMap.get(type);
                IntArray srcRels = this.relationshipMap.get(type);
                if (srcRels == null) {
                    this.relationshipMap.put(type, addRels);
                    continue;
                }
                srcRels.addAll(addRels);
            }
        }
        nodeManager.putAllInRelCache(pair.other());
        return true;
    }

    public Relationship createRelationshipTo(NodeManager nodeManager, Node otherNode, RelationshipType type) {
        return nodeManager.createRelationship(this, otherNode, type);
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    public boolean hasRelationship(NodeManager nodeManager) {
        return this.getRelationships(nodeManager).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType ... types) {
        return this.getRelationships(nodeManager, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction dir) {
        return this.getRelationships(nodeManager, dir).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getRelationships(nodeManager, type, dir).iterator().hasNext();
    }

    protected void commitRelationshipMaps(ArrayMap<String, IntArray> cowRelationshipAddMap, ArrayMap<String, IntArray> cowRelationshipRemoveMap) {
        IntArray remove;
        if (this.relationshipMap == null) {
            return;
        }
        if (cowRelationshipAddMap != null) {
            for (String type : cowRelationshipAddMap.keySet()) {
                IntArray add = cowRelationshipAddMap.get(type);
                remove = null;
                if (cowRelationshipRemoveMap != null) {
                    remove = cowRelationshipRemoveMap.get(type);
                }
                IntArray src = this.relationshipMap.get(type);
                this.relationshipMap.put(type, IntArray.composeNew(src, add, remove));
            }
        }
        if (cowRelationshipRemoveMap != null) {
            for (String type : cowRelationshipRemoveMap.keySet()) {
                if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null) continue;
                IntArray src = this.relationshipMap.get(type);
                remove = cowRelationshipRemoveMap.get(type);
                this.relationshipMap.put(type, IntArray.composeNew(src, null, remove));
            }
        }
    }

    RelationshipChainPosition getRelChainPosition() {
        return this.relChainPosition;
    }

    IntArray getIntArray(String type) {
        return this.relationshipMap.get(type);
    }

    ArrayMap<String, IntArray> getIntArrayMap() {
        return this.relationshipMap;
    }
}

