/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Version {
    VERSION;

    private final String title;
    private final String vendor;
    private final String version;
    private final String revision;

    public String toString() {
        if (this.title == null) {
            return "Neo4j Kernel, unpackaged version " + this.getVersion();
        }
        return this.title + " " + this.getVersion();
    }

    public String getVersion() {
        if (this.version == null) {
            return "<unknown>";
        }
        if (this.version.contains("SNAPSHOT")) {
            return this.version + " (revision: " + this.revision + ")";
        }
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    private Version() {
        Package pkg = ((Object)((Object)this)).getClass().getPackage();
        this.title = pkg.getImplementationTitle();
        this.vendor = pkg.getImplementationVendor();
        this.version = pkg.getImplementationVersion();
        String revision = null;
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            Attributes attr = manifest.getAttributes(pkg.getName().replace('.', '/'));
            if (attr == null) {
                attr = manifest.getMainAttributes();
            }
            if (attr != null) {
                revision = Version.revision(attr.getValue("Implementation-Revision"), attr.getValue("Implementation-Revision-Status"));
            }
        }
        this.revision = revision;
    }

    private static String revision(String revision, String status) {
        if (revision != null) {
            StringBuilder result = new StringBuilder(revision);
            if (status != null && (status = Version.mapOf(status).get("status")) != null) {
                result.append(status);
            }
            return result.toString();
        }
        return "";
    }

    private static Map<String, String> mapOf(String string) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : string.split(";")) {
            int start = part.indexOf(61);
            if (start == -1) {
                result.put(part, "true");
                continue;
            }
            result.put(part.substring(0, start), part.substring(start + 1));
        }
        return result;
    }

    private Manifest getManifest() {
        try {
            return new JarFile(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI())).getManifest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println((Object)VERSION);
    }

    static String get() {
        return VERSION.toString();
    }
}

