/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.IndexXaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexManagerImpl
implements IndexManager {
    private static final String KEY_INDEX_PROVIDER = "provider";
    private final IndexStore indexStore;
    private final Map<String, IndexProvider> indexProviders = new HashMap<String, IndexProvider>();
    private final EmbeddedGraphDbImpl graphDbImpl;

    IndexManagerImpl(EmbeddedGraphDbImpl graphDbImpl, IndexStore indexStore) {
        this.graphDbImpl = graphDbImpl;
        this.indexStore = indexStore;
    }

    private IndexProvider getIndexProvider(String provider) {
        Map<String, IndexProvider> map = this.indexProviders;
        synchronized (map) {
            IndexProvider result = this.indexProviders.get(provider);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("No index provider '" + provider + "' found");
        }
    }

    void addProvider(String name, IndexProvider provider) {
        this.indexProviders.put(name, provider);
    }

    private Pair<Map<String, String>, Boolean> findIndexConfig(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> suppliedConfig, Map<?, ?> dbConfig) {
        Map<String, String> storedConfig = this.indexStore.get(cls, indexName);
        if (storedConfig != null && suppliedConfig == null) {
            return Pair.of(storedConfig, Boolean.FALSE);
        }
        Map<String, String> configToUse = null;
        if (configToUse == null) {
            configToUse = suppliedConfig;
        }
        if (configToUse == null) {
            String provider = null;
            if (dbConfig != null && (provider = (String)dbConfig.get("index." + indexName)) == null) {
                provider = (String)dbConfig.get("index");
            }
            if (provider == null) {
                provider = "lucene";
            }
            IndexProvider indexProvider = this.getIndexProvider(provider);
            configToUse = indexProvider.fillInDefaults(MapUtil.stringMap(KEY_INDEX_PROVIDER, provider));
        }
        if (storedConfig != null) {
            if (suppliedConfig != null && !((Object)storedConfig).equals(suppliedConfig)) {
                throw new IllegalArgumentException("Supplied index configuration:\n" + suppliedConfig + "\ndiffer from stored config:\n" + storedConfig + "\nfor '" + indexName + "'");
            }
            configToUse = storedConfig;
        }
        boolean created = this.indexStore.setIfNecessary(cls, indexName, configToUse);
        return new Pair<Map<String, String>, Boolean>(Collections.unmodifiableMap(configToUse), created);
    }

    private Map<String, String> getOrCreateIndexConfig(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> suppliedConfig) {
        Pair<Map<String, String>, Boolean> result = this.findIndexConfig(cls, indexName, suppliedConfig, this.graphDbImpl.getConfig().getParams());
        if (result.other().booleanValue()) {
            IndexCreatorThread creator = new IndexCreatorThread(cls, indexName, result.first());
            creator.start();
            try {
                creator.join();
                if (creator.exception != null) {
                    throw new TransactionFailureException("Index creation failed for " + indexName + ", " + result.first(), creator.exception);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        return result.first();
    }

    @Override
    public boolean existsForNodes(String indexName) {
        return this.indexStore.get(Node.class, indexName) != null;
    }

    @Override
    public Index<Node> forNodes(String indexName) {
        Map<String, String> config = this.getOrCreateIndexConfig(Node.class, indexName, null);
        return this.getIndexProvider(config.get(KEY_INDEX_PROVIDER)).nodeIndex(indexName, config);
    }

    @Override
    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        Map<String, String> config = this.getOrCreateIndexConfig(Node.class, indexName, customConfiguration);
        return this.getIndexProvider(config.get(KEY_INDEX_PROVIDER)).nodeIndex(indexName, config);
    }

    @Override
    public String[] nodeIndexNames() {
        return this.indexStore.getNames(Node.class);
    }

    @Override
    public boolean existsForRelationships(String indexName) {
        return this.indexStore.get(Relationship.class, indexName) != null;
    }

    @Override
    public RelationshipIndex forRelationships(String indexName) {
        Map<String, String> config = this.getOrCreateIndexConfig(Relationship.class, indexName, null);
        return this.getIndexProvider(config.get(KEY_INDEX_PROVIDER)).relationshipIndex(indexName, config);
    }

    @Override
    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        Map<String, String> config = this.getOrCreateIndexConfig(Relationship.class, indexName, customConfiguration);
        return this.getIndexProvider(config.get(KEY_INDEX_PROVIDER)).relationshipIndex(indexName, config);
    }

    @Override
    public String[] relationshipIndexNames() {
        return this.indexStore.getNames(Relationship.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexCreatorThread
    extends Thread {
        private final String indexName;
        private final Map<String, String> config;
        private Exception exception;
        private final Class<? extends PropertyContainer> cls;

        IndexCreatorThread(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> config) {
            this.cls = cls;
            this.indexName = indexName;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String provider = this.config.get(IndexManagerImpl.KEY_INDEX_PROVIDER);
            String dataSourceName = IndexManagerImpl.this.getIndexProvider(provider).getDataSourceName();
            XaDataSource dataSource = IndexManagerImpl.this.graphDbImpl.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource(dataSourceName);
            IndexXaConnection connection = (IndexXaConnection)dataSource.getXaConnection();
            org.neo4j.graphdb.Transaction tx = IndexManagerImpl.this.graphDbImpl.beginTx();
            try {
                try {
                    Transaction javaxTx = IndexManagerImpl.this.graphDbImpl.getConfig().getTxModule().getTxManager().getTransaction();
                    javaxTx.enlistResource(connection.getXaResource());
                    connection.createIndex(this.cls, this.indexName, this.config);
                    tx.success();
                }
                catch (Exception e) {
                    this.exception = e;
                    Object var8_9 = null;
                    tx.finish();
                }
                Object var8_8 = null;
                tx.finish();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                tx.finish();
                throw throwable;
            }
        }
    }
}

