/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.impl.traversal.TraversalPath;
import org.neo4j.kernel.impl.traversal.TraverserImpl;

class TraversalBranchImpl
implements TraversalBranch {
    private final TraversalBranch parent;
    private final Node source;
    private Iterator<Relationship> relationships;
    private final Relationship howIGotHere;
    private final int depth;
    final TraverserImpl.TraverserIterator traverser;
    private Path path;
    private int expandedCount;

    TraversalBranchImpl(TraverserImpl.TraverserIterator traverser, TraversalBranch parent, int depth, Node source, RelationshipExpander expander, Relationship toHere) {
        this.traverser = traverser;
        this.parent = parent;
        this.source = source;
        this.howIGotHere = toHere;
        this.depth = depth;
        this.expandRelationships(true);
    }

    TraversalBranchImpl(TraverserImpl.TraverserIterator traverser, Node source, RelationshipExpander expander) {
        this.traverser = traverser;
        this.parent = null;
        this.source = source;
        this.howIGotHere = null;
        this.depth = 0;
    }

    protected void expandRelationships(boolean doChecks) {
        boolean okToExpand = !doChecks || this.traverser.shouldExpandBeyond(this);
        this.relationships = okToExpand ? this.traverser.description.expander.expand(this.source).iterator() : Collections.emptyList().iterator();
    }

    protected boolean hasExpandedRelationships() {
        return this.relationships != null;
    }

    public TraversalBranch next() {
        while (this.relationships.hasNext()) {
            Relationship relationship = this.relationships.next();
            if (relationship.equals(this.howIGotHere)) continue;
            ++this.expandedCount;
            Node node = relationship.getOtherNode(this.source);
            TraversalBranchImpl next = new TraversalBranchImpl(this.traverser, this, this.depth + 1, node, this.traverser.description.expander, relationship);
            if (!this.traverser.okToProceed(next)) continue;
            return next;
        }
        return null;
    }

    public Path position() {
        if (this.path == null) {
            this.path = new TraversalPath(this);
        }
        return this.path;
    }

    public int depth() {
        return this.depth;
    }

    public Relationship relationship() {
        return this.howIGotHere;
    }

    public Node node() {
        return this.source;
    }

    public TraversalBranch parent() {
        return this.parent;
    }

    public int expanded() {
        return this.expandedCount;
    }
}

