/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.OrderedByTypeExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class OldTraverserWrapper {
    private static final TraversalDescription BASE_DESCRIPTION = Traversal.description().uniqueness(Uniqueness.NODE_GLOBAL);

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException("Null " + message);
        }
    }

    public static Traverser traverse(Node node, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        OldTraverserWrapper.assertNotNull((Object)traversalOrder, "order");
        OldTraverserWrapper.assertNotNull(stopEvaluator, "stop evaluator");
        OldTraverserWrapper.assertNotNull(returnableEvaluator, "returnable evaluator");
        if (relationshipTypesAndDirections.length % 2 != 0 || relationshipTypesAndDirections.length == 0) {
            throw new IllegalArgumentException();
        }
        TraverserImpl result = new TraverserImpl();
        TraversalDescription description = OldTraverserWrapper.traversal(result, traversalOrder, stopEvaluator, returnableEvaluator);
        description = description.expand(OldTraverserWrapper.toExpander(relationshipTypesAndDirections));
        result.iter = description.traverse(node).iterator();
        return result;
    }

    private static RelationshipExpander toExpander(Object[] relationshipTypesAndDirections) {
        Stack<Object[]> entries = new Stack<Object[]>();
        for (int i = 0; i < relationshipTypesAndDirections.length; i += 2) {
            Object relType = relationshipTypesAndDirections[i];
            if (relType == null) {
                throw new IllegalArgumentException("Null relationship type at " + i);
            }
            if (!(relType instanceof RelationshipType)) {
                throw new IllegalArgumentException("Expected RelationshipType at var args pos " + i + ", found " + relType);
            }
            Object direction = relationshipTypesAndDirections[i + 1];
            if (direction == null) {
                throw new IllegalArgumentException("Null direction at " + (i + 1));
            }
            if (!(direction instanceof Direction)) {
                throw new IllegalArgumentException("Expected Direction at var args pos " + (i + 1) + ", found " + direction);
            }
            entries.push(new Object[]{relType, direction});
        }
        OrderedByTypeExpander expander = new OrderedByTypeExpander();
        while (!entries.isEmpty()) {
            Object[] entry = (Object[])entries.pop();
            expander = (OrderedByTypeExpander)expander.add((RelationshipType)entry[0], (Direction)((Object)entry[1]));
        }
        return expander;
    }

    private static TraversalDescription traversal(TraverserImpl traverser, Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        TraversalDescription description = BASE_DESCRIPTION;
        switch (order) {
            case BREADTH_FIRST: {
                description = description.breadthFirst();
                break;
            }
            case DEPTH_FIRST: {
                description = description.depthFirst();
                break;
            }
            default: {
                throw new IllegalArgumentException("Onsupported traversal order: " + (Object)((Object)order));
            }
        }
        description = description.prune(new Pruner(traverser, stopEvaluator));
        description = description.filter(new Filter(traverser, returnableEvaluator));
        return description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Filter
    implements Predicate<Path> {
        private final TraverserImpl traverser;
        private final ReturnableEvaluator evaluator;

        Filter(TraverserImpl traverser, ReturnableEvaluator returnableEvaluator) {
            this.traverser = traverser;
            this.evaluator = returnableEvaluator;
        }

        @Override
        public boolean accept(Path position) {
            return this.evaluator.isReturnableNode(new PositionImpl(this.traverser, position));
        }
    }

    private static class Pruner
    implements PruneEvaluator {
        private final TraverserImpl traverser;
        private final StopEvaluator evaluator;

        Pruner(TraverserImpl traverser, StopEvaluator stopEvaluator) {
            this.traverser = traverser;
            this.evaluator = stopEvaluator;
        }

        public boolean pruneAfter(Path position) {
            return this.evaluator.isStopNode(new PositionImpl(this.traverser, position));
        }
    }

    private static class PositionImpl
    implements TraversalPosition {
        private final Path position;
        private final int count;

        PositionImpl(TraverserImpl traverser, Path position) {
            this.position = position;
            this.count = traverser.count;
        }

        public Node currentNode() {
            return this.position.endNode();
        }

        public int depth() {
            return this.position.length();
        }

        public boolean isStartNode() {
            return this.position.length() == 0;
        }

        public boolean notStartNode() {
            return !this.isStartNode();
        }

        public Relationship lastRelationshipTraversed() {
            return this.position.lastRelationship();
        }

        public Node previousNode() {
            return this.position.lastRelationship().getOtherNode(this.position.endNode());
        }

        public int returnedNodesCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TraverserImpl
    implements Traverser,
    Iterator<Node> {
        private TraversalPosition currentPos;
        private Iterator<Path> iter;
        private int count;

        private TraverserImpl() {
        }

        @Override
        public TraversalPosition currentPosition() {
            return this.currentPos;
        }

        @Override
        public Collection<Node> getAllNodes() {
            ArrayList<Node> result = new ArrayList<Node>();
            for (Node node : this) {
                result.add(node);
            }
            return result;
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Node next() {
            this.currentPos = new PositionImpl(this, this.iter.next());
            ++this.count;
            return this.currentPos.currentNode();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

