/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;

public class XaResourceManager {
    private final ArrayMap<XAResource, Xid> xaResourceMap = new ArrayMap();
    private final ArrayMap<Xid, XidStatus> xidMap = new ArrayMap();
    private int recoveredTxCount = 0;
    private Set<Integer> recoveredDoneRecords = new HashSet<Integer>();
    private XaLogicalLog log = null;
    private final XaTransactionFactory tf;
    private final String name;
    private StringLogger msgLog;
    private Map<Xid, Integer> txOrderMap = new HashMap<Xid, Integer>();
    private int nextTxOrder = 0;

    XaResourceManager(XaTransactionFactory tf, String name) {
        this.tf = tf;
        this.name = name;
    }

    synchronized void setLogicalLog(XaLogicalLog log) {
        this.log = log;
        this.msgLog = log.getStringLogger();
    }

    synchronized XaTransaction getXaTransaction(XAResource xaRes) throws XAException {
        XidStatus status = this.xidMap.get(this.xaResourceMap.get(xaRes));
        if (status == null) {
            throw new XAException("Resource[" + xaRes + "] not enlisted");
        }
        return status.getTransactionStatus().getTransaction();
    }

    synchronized void start(XAResource xaResource, Xid xid) throws XAException {
        if (this.xaResourceMap.get(xaResource) != null) {
            throw new XAException("Resource[" + xaResource + "] already enlisted or suspended");
        }
        this.xaResourceMap.put(xaResource, xid);
        if (this.xidMap.get(xid) == null) {
            int identifier = this.log.start(xid);
            XaTransaction xaTx = this.tf.create(identifier);
            this.xidMap.put(xid, new XidStatus(xaTx));
        }
    }

    synchronized void injectStart(Xid xid, XaTransaction tx) throws IOException {
        if (this.xidMap.get(xid) != null) {
            throw new IOException("Inject start failed, xid: " + xid + " already injected");
        }
        this.xidMap.put(xid, new XidStatus(tx));
        ++this.recoveredTxCount;
    }

    synchronized void resume(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (status.getActive()) {
            throw new XAException("Xid [" + xid + "] not suspended");
        }
        status.setActive(true);
    }

    synchronized void join(XAResource xaResource, Xid xid) throws XAException {
        if (this.xidMap.get(xid) == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (this.xaResourceMap.get(xaResource) != null) {
            throw new XAException("Resource[" + xaResource + "] already enlisted");
        }
        this.xaResourceMap.put(xaResource, xid);
    }

    synchronized void end(XAResource xaResource, Xid xid) throws XAException {
        Xid xidEntry = this.xaResourceMap.remove(xaResource);
        if (xidEntry == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
    }

    synchronized void suspend(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        if (!status.getActive()) {
            throw new XAException("Xid[" + xid + "] already suspended");
        }
        status.setActive(false);
    }

    synchronized void fail(XAResource xaResource, Xid xid) throws XAException {
        if (this.xidMap.get(xid) == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        Xid xidEntry = this.xaResourceMap.remove(xaResource);
        if (xidEntry == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
        XidStatus status = this.xidMap.get(xid);
        status.getTransactionStatus().markAsRollback();
    }

    synchronized void validate(XAResource xaResource) throws XAException {
        XidStatus status = this.xidMap.get(this.xaResourceMap.get(xaResource));
        if (status == null) {
            throw new XAException("Resource[" + xaResource + "] not enlisted");
        }
        if (!status.getActive()) {
            throw new XAException("Resource[" + xaResource + "] suspended");
        }
    }

    synchronized void destroy(XAResource xaResource) {
        this.xaResourceMap.remove(xaResource);
    }

    synchronized int prepare(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (xaTransaction.isReadOnly()) {
            this.log.done(xaTransaction.getIdentifier());
            this.xidMap.remove(xid);
            if (xaTransaction.isRecovered()) {
                --this.recoveredTxCount;
                this.checkIfRecoveryComplete();
            }
            return 3;
        }
        xaTransaction.prepare();
        this.log.prepare(xaTransaction.getIdentifier());
        txStatus.markAsPrepared();
        return 0;
    }

    synchronized boolean injectPrepare(Xid xid) throws IOException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new IOException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (xaTransaction.isReadOnly()) {
            this.xidMap.remove(xid);
            if (xaTransaction.isRecovered()) {
                --this.recoveredTxCount;
                this.checkIfRecoveryComplete();
            }
            return true;
        }
        this.txOrderMap.put(xid, this.nextTxOrder++);
        txStatus.markAsPrepared();
        return false;
    }

    synchronized void injectOnePhaseCommit(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        this.txOrderMap.put(xid, this.nextTxOrder++);
        txStatus.markAsPrepared();
        txStatus.markCommitStarted();
        XaTransaction xaTransaction = txStatus.getTransaction();
        xaTransaction.commit();
    }

    synchronized void injectTwoPhaseCommit(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        this.txOrderMap.put(xid, this.nextTxOrder++);
        txStatus.markAsPrepared();
        txStatus.markCommitStarted();
        XaTransaction xaTransaction = txStatus.getTransaction();
        xaTransaction.commit();
    }

    synchronized XaTransaction commit(Xid xid, boolean onePhase) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (onePhase) {
            if (!xaTransaction.isReadOnly() && !xaTransaction.isRecovered()) {
                xaTransaction.prepare();
                this.log.commitOnePhase(xaTransaction.getIdentifier());
            }
            txStatus.markAsPrepared();
        }
        if (!txStatus.prepared() || txStatus.rollback()) {
            throw new XAException("Transaction not prepared or (marked as) rolledbacked");
        }
        if (!xaTransaction.isReadOnly()) {
            if (!xaTransaction.isRecovered() && !onePhase) {
                this.log.commitTwoPhase(xaTransaction.getIdentifier());
            }
            txStatus.markCommitStarted();
            xaTransaction.commit();
        }
        if (!xaTransaction.isRecovered()) {
            this.log.done(xaTransaction.getIdentifier());
        } else if (!this.log.scanIsComplete() || this.recoveredTxCount > 0) {
            this.recoveredDoneRecords.add(xaTransaction.getIdentifier());
        }
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            --this.recoveredTxCount;
            this.checkIfRecoveryComplete();
        }
        return xaTransaction;
    }

    synchronized XaTransaction rollback(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        if (txStatus.commitStarted()) {
            throw new XAException("Transaction already started commit");
        }
        txStatus.markAsRollback();
        xaTransaction.rollback();
        this.log.done(xaTransaction.getIdentifier());
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            --this.recoveredTxCount;
            this.checkIfRecoveryComplete();
        }
        return txStatus.getTransaction();
    }

    synchronized XaTransaction forget(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.log.done(xaTransaction.getIdentifier());
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            --this.recoveredTxCount;
            this.checkIfRecoveryComplete();
        }
        return xaTransaction;
    }

    synchronized void markAsRollbackOnly(Xid xid) throws XAException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new XAException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        txStatus.markAsRollback();
    }

    synchronized Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        Iterator<Xid> keyIterator = this.xidMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            xids.add(keyIterator.next());
        }
        return xids.toArray(new Xid[xids.size()]);
    }

    synchronized void pruneXid(Xid xid) throws IOException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            throw new IOException("Unknown xid[" + xid + "]");
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            this.recoveredDoneRecords.remove(xaTransaction.getIdentifier());
            --this.recoveredTxCount;
            this.checkIfRecoveryComplete();
        }
    }

    synchronized void pruneXidIfExist(Xid xid) throws IOException {
        XidStatus status = this.xidMap.get(xid);
        if (status == null) {
            return;
        }
        TransactionStatus txStatus = status.getTransactionStatus();
        XaTransaction xaTransaction = txStatus.getTransaction();
        this.xidMap.remove(xid);
        if (xaTransaction.isRecovered()) {
            --this.recoveredTxCount;
            this.checkIfRecoveryComplete();
        }
    }

    synchronized void checkXids() throws IOException {
        this.msgLog.logMessage("XaResourceManager[" + this.name + "] sorting " + this.xidMap.size() + " xids");
        Iterator<Xid> keyIterator = this.xidMap.keySet().iterator();
        LinkedList<Xid> xids = new LinkedList<Xid>();
        while (keyIterator.hasNext()) {
            xids.add(keyIterator.next());
        }
        Collections.sort(xids, new Comparator<Xid>(){

            @Override
            public int compare(Xid o1, Xid o2) {
                Integer id1 = (Integer)XaResourceManager.this.txOrderMap.get(o1);
                Integer id2 = (Integer)XaResourceManager.this.txOrderMap.get(o2);
                if (id1 == null && id2 == null) {
                    return 0;
                }
                if (id1 == null) {
                    return Integer.MAX_VALUE;
                }
                if (id2 == null) {
                    return Integer.MIN_VALUE;
                }
                return id1 - id2;
            }
        });
        this.txOrderMap.clear();
        Logger logger = Logger.getLogger(this.tf.getClass().getName());
        while (!xids.isEmpty()) {
            Xid xid = (Xid)xids.removeFirst();
            XidStatus status = this.xidMap.get(xid);
            TransactionStatus txStatus = status.getTransactionStatus();
            XaTransaction xaTransaction = txStatus.getTransaction();
            int identifier = xaTransaction.getIdentifier();
            if (!xaTransaction.isRecovered()) continue;
            if (txStatus.commitStarted()) {
                logger.fine("Marking 1PC [" + this.name + "] tx " + identifier + " as done");
                this.log.doneInternal(identifier);
                this.xidMap.remove(xid);
                --this.recoveredTxCount;
                continue;
            }
            if (!txStatus.prepared()) {
                logger.fine("Rolling back non prepared tx [" + this.name + "]" + "txIdent[" + identifier + "]");
                this.log.doneInternal(xaTransaction.getIdentifier());
                this.xidMap.remove(xid);
                --this.recoveredTxCount;
                continue;
            }
            logger.fine("2PC tx [" + this.name + "] " + txStatus + " txIdent[" + identifier + "]");
        }
        this.checkIfRecoveryComplete();
    }

    private void checkIfRecoveryComplete() {
        this.msgLog.logMessage("XaResourceManager[" + this.name + "] checkRecoveryComplete " + this.xidMap.size() + " xids");
        if (this.log.scanIsComplete() && this.recoveredTxCount == 0) {
            this.tf.recoveryComplete();
            try {
                for (int identifier : this.recoveredDoneRecords) {
                    this.log.doneInternal(identifier);
                }
                this.recoveredDoneRecords.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.msgLog.logMessage("XaResourceManager[" + this.name + "] recovery completed.");
        } else {
            this.msgLog.logMessage("XaResourceManager[" + this.name + "] recovery not completed, xidCount=" + this.recoveredTxCount + " waiting for global tm");
        }
    }

    synchronized void reset() {
        this.xaResourceMap.clear();
        this.xidMap.clear();
        this.log.reset();
    }

    public boolean hasRecoveredTransactions() {
        return this.recoveredTxCount > 0;
    }

    private static class TransactionStatus {
        private boolean prepared = false;
        private boolean commitStarted = false;
        private boolean rollback = false;
        private final XaTransaction xaTransaction;

        TransactionStatus(XaTransaction xaTransaction) {
            this.xaTransaction = xaTransaction;
        }

        void markAsPrepared() {
            this.prepared = true;
        }

        void markAsRollback() {
            this.rollback = true;
        }

        void markCommitStarted() {
            this.commitStarted = true;
        }

        boolean prepared() {
            return this.prepared;
        }

        boolean rollback() {
            return this.rollback;
        }

        boolean commitStarted() {
            return this.commitStarted;
        }

        XaTransaction getTransaction() {
            return this.xaTransaction;
        }

        public String toString() {
            return "TransactionStatus[" + this.xaTransaction.getIdentifier() + ", prepared=" + this.prepared + ", commitStarted=" + this.commitStarted + ", rolledback=" + this.rollback + "]";
        }
    }

    private static class XidStatus {
        private boolean active = true;
        private TransactionStatus txStatus;

        XidStatus(XaTransaction xaTransaction) {
            this.txStatus = new TransactionStatus(xaTransaction);
        }

        void setActive(boolean active) {
            this.active = active;
        }

        boolean getActive() {
            return this.active;
        }

        TransactionStatus getTransactionStatus() {
            return this.txStatus;
        }
    }
}

