/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

class DirectMappedLogBuffer
implements LogBuffer {
    private static final int BUFFER_SIZE = 0x200000;
    private final FileChannel fileChannel;
    private ByteBuffer byteBuffer = null;
    private long bufferStartPosition;

    DirectMappedLogBuffer(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this.bufferStartPosition = fileChannel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(0x200000);
    }

    private void getNewDirectBuffer() throws IOException {
        this.byteBuffer.flip();
        this.bufferStartPosition += (long)this.fileChannel.write(this.byteBuffer, this.bufferStartPosition);
        this.byteBuffer.clear();
    }

    private void ensureCapacity(int plusSize) throws IOException {
        if (this.byteBuffer == null || 0x200000 - this.byteBuffer.position() < plusSize) {
            this.getNewDirectBuffer();
        }
    }

    public LogBuffer put(byte b) throws IOException {
        this.ensureCapacity(1);
        this.byteBuffer.put(b);
        return this;
    }

    public LogBuffer putInt(int i) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putInt(i);
        return this;
    }

    public LogBuffer putLong(long l) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putLong(l);
        return this;
    }

    public LogBuffer putFloat(float f) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putFloat(f);
        return this;
    }

    public LogBuffer putDouble(double d) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putDouble(d);
        return this;
    }

    public LogBuffer put(byte[] bytes) throws IOException {
        this.put(bytes, 0);
        return this;
    }

    private void put(byte[] bytes, int offset) throws IOException {
        int bytesToWrite = bytes.length - offset;
        if (bytesToWrite > 0x200000) {
            bytesToWrite = 0x200000;
        }
        this.ensureCapacity(bytesToWrite);
        this.byteBuffer.put(bytes, offset, bytesToWrite);
        if ((offset += bytesToWrite) < bytes.length) {
            this.put(bytes, offset);
        }
    }

    public LogBuffer put(char[] chars) throws IOException {
        this.put(chars, 0);
        return this;
    }

    private void put(char[] chars, int offset) throws IOException {
        int charsToWrite = chars.length - offset;
        if (charsToWrite * 2 > 0x200000) {
            charsToWrite = 0x100000;
        }
        this.ensureCapacity(charsToWrite * 2);
        int oldPos = this.byteBuffer.position();
        this.byteBuffer.asCharBuffer().put(chars, offset, charsToWrite);
        this.byteBuffer.position(oldPos + charsToWrite * 2);
        if ((offset += charsToWrite) < chars.length) {
            this.put(chars, offset);
        }
    }

    public void force() throws IOException {
        this.getNewDirectBuffer();
        this.fileChannel.force(false);
    }

    public long getFileChannelPosition() {
        if (this.byteBuffer != null) {
            return this.bufferStartPosition + (long)this.byteBuffer.position();
        }
        return this.bufferStartPosition;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

