/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipStore
extends AbstractStore
implements Store {
    private static final String VERSION = "RelationshipStore v0.9.5";
    private static final int RECORD_SIZE = 33;

    public RelationshipStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public RelationshipStore(String fileName) {
        super(fileName);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 33;
    }

    @Override
    public void close() {
        super.close();
    }

    public static void createStore(String fileName) {
        RelationshipStore.createEmptyStore(fileName, VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getRecord(int id) {
        RelationshipRecord relationshipRecord;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            RelationshipRecord record;
            relationshipRecord = record = this.getRecord(id, window, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
        return relationshipRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getLightRel(int id) {
        RelationshipRecord relationshipRecord;
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            RelationshipRecord record;
            relationshipRecord = record = this.getRecord(id, window, true);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
        return relationshipRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unsetRecovered();
            throw throwable;
        }
        this.unsetRecovered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
    }

    private void updateRecord(RelationshipRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            buffer.put(inUse).putInt(record.getFirstNode()).putInt(record.getSecondNode()).putInt(record.getType()).putInt(record.getFirstPrevRel()).putInt(record.getFirstNextRel()).putInt(record.getSecondPrevRel()).putInt(record.getSecondNextRel()).putInt(record.getNextProp());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    private RelationshipRecord getRecord(int id, PersistenceWindow window, boolean check) {
        boolean inUseFlag;
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUse = buffer.get();
        boolean bl = inUseFlag = (inUse & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue();
        if (!inUseFlag) {
            if (check) {
                return null;
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        RelationshipRecord record = new RelationshipRecord(id, buffer.getInt(), buffer.getInt(), buffer.getInt());
        record.setInUse(inUseFlag);
        record.setFirstPrevRel(buffer.getInt());
        record.setFirstNextRel(buffer.getInt());
        record.setSecondPrevRel(buffer.getInt());
        record.setSecondNextRel(buffer.getInt());
        record.setNextProp(buffer.getInt());
        return record;
    }

    private RelationshipRecord getFullRecord(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUse = buffer.get();
        boolean inUseFlag = (inUse & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue();
        RelationshipRecord record = new RelationshipRecord(id, buffer.getInt(), buffer.getInt(), buffer.getInt());
        record.setInUse(inUseFlag);
        record.setFirstPrevRel(buffer.getInt());
        record.setFirstNextRel(buffer.getInt());
        record.setSecondPrevRel(buffer.getInt());
        record.setSecondNextRel(buffer.getInt());
        record.setNextProp(buffer.getInt());
        return record;
    }

    public String toString() {
        return "RelStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("RelationshipStore")) {
            return false;
        }
        if (version.equals("RelationshipStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getChainRecord(int relId) {
        RelationshipRecord relationshipRecord;
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(relId, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            relationshipRecord = this.getFullRecord(relId, window);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseWindow(window);
            throw throwable;
        }
        this.releaseWindow(window);
        return relationshipRecord;
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }
}

