/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.ReadOnlyIdGenerator;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAbstractStore {
    protected static final Logger logger = Logger.getLogger(CommonAbstractStore.class.getName());
    protected static final int DEFAULT_ID_GRAB_SIZE = 1024;
    private final String storageFileName;
    private IdGenerator idGenerator = null;
    private FileChannel fileChannel = null;
    private PersistenceWindowPool windowPool;
    private boolean storeOk = true;
    private FileLock fileLock;
    private boolean grabFileLock = true;
    private Map<?, ?> config = null;
    private boolean readOnly = false;
    private boolean backupSlave = false;
    private boolean isRecovered = false;

    public abstract String getTypeAndVersionDescriptor();

    protected void initStorage() {
    }

    protected boolean versionFound(String version) {
        return true;
    }

    protected void closeStorage() {
    }

    protected abstract void loadStorage();

    protected abstract void rebuildIdGenerator();

    public CommonAbstractStore(String fileName, Map<?, ?> config) {
        String fileLock;
        this.storageFileName = fileName;
        this.config = config;
        if (config != null && (fileLock = (String)config.get("grab_file_lock")) != null && fileLock.toLowerCase().equals("false")) {
            this.grabFileLock = false;
        }
        this.checkStorage();
        this.loadStorage();
        this.initStorage();
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    public CommonAbstractStore(String fileName) {
        this.storageFileName = fileName;
        this.checkStorage();
        this.loadStorage();
        this.initStorage();
    }

    private void checkStorage() {
        String str;
        Boolean isReadOnly;
        if (this.config != null && (isReadOnly = (Boolean)this.config.get("read_only")) != null) {
            this.readOnly = isReadOnly;
        }
        if (this.config != null && "true".equals(str = (String)this.config.get("backup_slave"))) {
            this.backupSlave = true;
        }
        if (!new File(this.storageFileName).exists()) {
            throw new IllegalStateException("No such store[" + this.storageFileName + "]");
        }
        try {
            this.fileChannel = !this.readOnly || this.backupSlave ? new RandomAccessFile(this.storageFileName, "rw").getChannel() : new RandomAccessFile(this.storageFileName, "r").getChannel();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
        try {
            if ((!this.readOnly || this.backupSlave) && this.grabFileLock) {
                this.fileLock = this.fileChannel.tryLock();
                if (this.fileLock == null) {
                    this.fileChannel.close();
                    throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually a result of some " + "other Neo4j kernel running using the same store.");
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to lock store[" + this.storageFileName + "]");
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("Unable to lock store [" + this.storageFileName + "], this is usually caused by another Neo4j kernel already running in " + "this JVM for this particular store");
        }
    }

    protected void setStoreNotOk() {
        if (this.readOnly && !this.isBackupSlave()) {
            throw new UnderlyingStorageException("Cannot start up on non clean store as read only");
        }
        this.storeOk = false;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void setWindowPool(PersistenceWindowPool pool) {
        this.windowPool = pool;
    }

    public int nextId() {
        return (int)this.idGenerator.nextId();
    }

    public void freeId(int id) {
        this.idGenerator.freeId(this.makeUnsignedInt(id));
    }

    private long makeUnsignedInt(int signedInteger) {
        return (long)signedInteger & 0xFFFFFFFFL;
    }

    protected long getHighId() {
        return this.idGenerator.getHighId();
    }

    protected void setHighId(long highId) {
        if (this.idGenerator != null) {
            this.idGenerator.setHighId(highId);
        }
    }

    protected boolean getIfMemoryMapped() {
        String useMemMapped;
        return this.getConfig() == null || (useMemMapped = (String)this.getConfig().get("use_memory_mapped_buffers")) == null || !useMemMapped.toLowerCase().equals("false");
    }

    protected long getMappedMem() {
        if (this.getConfig() != null) {
            String convertSlash = this.storageFileName.replace('\\', '/');
            String realName = convertSlash.substring(convertSlash.lastIndexOf(47) + 1);
            String mem = (String)this.getConfig().get(realName + ".mapped_memory");
            if (mem != null) {
                long multiplier = 1L;
                if (mem.endsWith("M")) {
                    multiplier = 0x100000L;
                    mem = mem.substring(0, mem.length() - 1);
                } else if (mem.endsWith("k")) {
                    multiplier = 1024L;
                    mem = mem.substring(0, mem.length() - 1);
                } else if (mem.endsWith("G")) {
                    multiplier = 0x40000000L;
                    mem = mem.substring(0, mem.length() - 1);
                }
                try {
                    return (long)Integer.parseInt(mem) * multiplier;
                }
                catch (NumberFormatException e) {
                    logger.info("Unable to parse mapped memory[" + mem + "] string for " + this.storageFileName);
                }
            }
        }
        return 0L;
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            if (this.readOnly && !this.backupSlave) {
                throw new ReadOnlyDbException();
            }
            this.rebuildIdGenerator();
            this.storeOk = true;
        }
    }

    public void rebuildIdGenerators() {
        if (this.readOnly && !this.backupSlave) {
            throw new ReadOnlyDbException();
        }
        this.rebuildIdGenerator();
    }

    public Map<?, ?> getConfig() {
        return this.config;
    }

    protected PersistenceWindow acquireWindow(int sPosition, OperationType type) {
        long position = this.makeUnsignedInt(sPosition);
        if (!(this.isInRecoveryMode() || position <= this.idGenerator.getHighId() && this.storeOk)) {
            throw new InvalidRecordException("Position[" + position + "] requested for operation is high id[" + this.idGenerator.getHighId() + "] or store is flagged as dirty[" + this.storeOk + "]");
        }
        return this.windowPool.acquire(position, type);
    }

    protected void releaseWindow(PersistenceWindow window) {
        this.windowPool.release(window);
    }

    public void flushAll() {
        this.windowPool.flushAll();
    }

    protected boolean isInRecoveryMode() {
        return this.isRecovered;
    }

    protected void setRecovered() {
        this.isRecovered = true;
    }

    protected void unsetRecovered() {
        this.isRecovered = false;
    }

    public String getStorageFileName() {
        return this.storageFileName;
    }

    protected void openIdGenerator() {
        this.idGenerator = new IdGeneratorImpl(this.storageFileName + ".id", 1024);
    }

    protected void openReadOnlyIdGenerator(int recordSize) {
        try {
            this.idGenerator = new ReadOnlyIdGenerator(this.storageFileName + ".id", this.fileChannel.size() / (long)recordSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    public void close() {
        if (this.fileChannel == null) {
            return;
        }
        this.closeStorage();
        if (this.windowPool != null) {
            this.windowPool.close();
            this.windowPool = null;
        }
        if (this.isReadOnly() && !this.isBackupSlave()) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            return;
        }
        long highId = this.idGenerator.getHighId();
        int recordSize = -1;
        if (this instanceof AbstractDynamicStore) {
            recordSize = ((AbstractDynamicStore)this).getBlockSize();
        } else if (this instanceof AbstractStore) {
            recordSize = ((AbstractStore)this).getRecordSize();
        }
        this.closeIdGenerator();
        boolean success = false;
        IOException storedIoe = null;
        if (!this.readOnly || this.backupSlave) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.fileChannel.position(highId * (long)recordSize);
                    ByteBuffer buffer = ByteBuffer.wrap(this.getTypeAndVersionDescriptor().getBytes());
                    this.fileChannel.write(buffer);
                    this.fileChannel.truncate(this.fileChannel.position());
                    this.fileChannel.force(false);
                    this.fileLock.release();
                    this.fileChannel.close();
                    this.fileChannel = null;
                    success = true;
                    break;
                }
                catch (IOException e) {
                    storedIoe = e;
                    System.gc();
                    continue;
                }
            }
        } else {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!success) {
            throw new UnderlyingStorageException("Unable to close store " + this.getStorageFileName(), storedIoe);
        }
    }

    protected final FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getHighestPossibleIdInUse() {
        return this.idGenerator.getHighId() - 1L;
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public WindowPoolStats getWindowPoolStats() {
        return this.windowPool.getStats();
    }
}

