/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.management.TransactionManager;

@Description(value="Information about the Neo4j transaction manager")
class TransactionManagerBean
extends Neo4jMBean
implements TransactionManager {
    private final TxModule txModule;

    TransactionManagerBean(String instanceId, TxModule txModule) throws NotCompliantMBeanException {
        super(instanceId, TransactionManager.class);
        this.txModule = txModule;
    }

    @Description(value="The number of currently open transactions")
    public int getNumberOfOpenTransactions() {
        return this.txModule.getActiveTxCount();
    }

    @Description(value="The highest number of transactions ever opened concurrently")
    public int getPeakNumberOfConcurrentTransactions() {
        return this.txModule.getPeakConcurrentTxCount();
    }

    @Description(value="The total number started transactions")
    public int getNumberOfOpenedTransactions() {
        return this.txModule.getStartedTxCount();
    }

    @Description(value="The total number of committed transactions")
    public long getNumberOfCommittedTransactions() {
        return this.txModule.getCommittedTxCount();
    }

    @Description(value="The total number of rolled back transactions")
    public long getNumberOfRolledBackTransactions() {
        return this.txModule.getRolledbackTxCount();
    }
}

