/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.management;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.management.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.management.Kernel;

@Description(value="Information about the Neo4j kernel")
class KernelBean
extends Neo4jMBean
implements Kernel {
    private final long kernelStartTime;
    private final long storeCreationDate;
    private final long storeId;
    private final long storeLogVersion;
    private final boolean isReadOnly;
    private final String kernelVersion;
    private final String storeDir;
    private final ObjectName query;

    KernelBean(String instanceId, String kernelVersion, NeoStoreXaDataSource datasource, ObjectName query) throws NotCompliantMBeanException {
        super(instanceId, Kernel.class);
        String storeDir;
        this.kernelVersion = kernelVersion;
        this.query = query;
        this.storeCreationDate = datasource.getCreationTime();
        this.storeLogVersion = datasource.getCurrentLogVersion();
        this.isReadOnly = datasource.isReadOnly();
        this.storeId = datasource.getRandomIdentifier();
        try {
            storeDir = new File(datasource.getStoreDir()).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            storeDir = new File(datasource.getStoreDir()).getAbsolutePath();
        }
        this.storeDir = storeDir;
        this.kernelStartTime = new Date().getTime();
    }

    @Description(value="An ObjectName that can be used as a query for getting all management beans for this Neo4j instance.")
    public ObjectName getMBeanQuery() {
        return this.query;
    }

    @Description(value="The time from which this Neo4j instance was in operational mode")
    public Date getKernelStartTime() {
        return new Date(this.kernelStartTime);
    }

    @Description(value="The time when this Neo4j graph store was created")
    public Date getStoreCreationDate() {
        return new Date(this.storeCreationDate);
    }

    @Description(value="A identifier that uniquely identifies this Neo4j graph store")
    public String getStoreId() {
        return Long.toHexString(this.storeId);
    }

    @Description(value="The current version of the Neo4j store logical log")
    public long getStoreLogVersion() {
        return this.storeLogVersion;
    }

    @Description(value="The version of Neo4j")
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Description(value="Whether this is a read only instance")
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Description(value="The location where the Neo4j store is located")
    public String getStoreDirectory() {
        return this.storeDir;
    }
}

