/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.cache.NoCache;
import org.neo4j.kernel.impl.cache.SoftLruCache;
import org.neo4j.kernel.impl.cache.WeakLruCache;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.persistence.IdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeManager {
    private static Logger log = Logger.getLogger(NodeManager.class.getName());
    private int referenceNodeId = 0;
    private final GraphDatabaseService graphDbService;
    private final Cache<Integer, NodeImpl> nodeCache;
    private final Cache<Integer, RelationshipImpl> relCache;
    private final AdaptiveCacheManager cacheManager;
    private final CacheType cacheType;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private final LockReleaser lockReleaser;
    private final PropertyIndexManager propertyIndexManager;
    private final RelationshipTypeHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final IdGenerator idGenerator;
    private boolean useAdaptiveCache = false;
    private float adaptiveCacheHeapRatio = 0.77f;
    private int minNodeCacheSize = 0;
    private int minRelCacheSize = 0;
    private int maxNodeCacheSize = 1500;
    private int maxRelCacheSize = 3500;
    private static final int LOCK_STRIPE_COUNT = 32;
    private final ReentrantLock[] loadLocks = new ReentrantLock[32];

    NodeManager(GraphDatabaseService graphDb, AdaptiveCacheManager cacheManager, LockManager lockManager, LockReleaser lockReleaser, TransactionManager transactionManager, PersistenceManager persistenceManager, IdGenerator idGenerator, CacheType cacheType) {
        this.graphDbService = graphDb;
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.propertyIndexManager = new PropertyIndexManager(transactionManager, persistenceManager, idGenerator);
        this.lockReleaser = lockReleaser;
        lockReleaser.setNodeManager(this);
        lockReleaser.setPropertyIndexManager(this.propertyIndexManager);
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.relTypeHolder = new RelationshipTypeHolder(transactionManager, persistenceManager, idGenerator);
        this.cacheType = cacheType;
        this.nodeCache = cacheType.node(cacheManager);
        this.relCache = cacheType.relationship(cacheManager);
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    private void parseParams(Map<Object, Object> params) {
        Object value;
        if (params.containsKey("use_adaptive_cache")) {
            value = (String)params.get("use_adaptive_cache");
            if (((String)value).toLowerCase().equals("yes")) {
                this.useAdaptiveCache = true;
            } else if (((String)value).toLowerCase().equals("no")) {
                this.useAdaptiveCache = false;
            } else {
                log.warning("Unable to parse use_adaptive_cache=" + (String)value);
            }
        }
        if (params.containsKey("adaptive_cache_heap_ratio")) {
            value = params.get("adaptive_cache_heap_ratio");
            try {
                this.adaptiveCacheHeapRatio = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse adaptive_cache_heap_ratio " + value);
            }
            if (this.adaptiveCacheHeapRatio < 0.1f) {
                this.adaptiveCacheHeapRatio = 0.1f;
            }
            if (this.adaptiveCacheHeapRatio > 0.95f) {
                this.adaptiveCacheHeapRatio = 0.95f;
            }
        }
        if (params.containsKey("min_node_cache_size")) {
            value = params.get("min_node_cache_size");
            try {
                this.minNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_node_cache_size " + value);
            }
        }
        if (params.containsKey("min_relationship_cache_size")) {
            value = params.get("min_relationship_cache_size");
            try {
                this.minRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_relationship_cache_size " + value);
            }
        }
        if (params.containsKey("max_node_cache_size")) {
            value = params.get("max_node_cache_size");
            try {
                this.maxNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_node_cache_size " + value);
            }
        }
        if (params.containsKey("max_relationship_cache_size")) {
            value = params.get("max_relationship_cache_size");
            try {
                this.maxRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_relationship_cache_size " + value);
            }
        }
    }

    public void start(Map<Object, Object> params) {
        this.parseParams(params);
        this.nodeCache.resize(this.maxNodeCacheSize);
        this.relCache.resize(this.maxRelCacheSize);
        if (this.useAdaptiveCache && this.cacheType.needsCacheManagerRegistration) {
            this.cacheManager.registerCache(this.nodeCache, this.adaptiveCacheHeapRatio, this.minNodeCacheSize);
            this.cacheManager.registerCache(this.relCache, this.adaptiveCacheHeapRatio, this.minRelCacheSize);
            this.cacheManager.start(params);
        }
    }

    public void stop() {
        if (this.useAdaptiveCache && this.cacheType.needsCacheManagerRegistration) {
            this.cacheManager.stop();
            this.cacheManager.unregisterCache(this.nodeCache);
            this.cacheManager.unregisterCache(this.relCache);
        }
        this.relTypeHolder.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        int id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, true);
        this.acquireLock(node, LockType.WRITE);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            this.nodeCache.put(id, node);
            success = true;
            NodeProxy nodeProxy = new NodeProxy(id, this);
            return nodeProxy;
        }
        finally {
            this.releaseLock(node, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(NodeImpl startNode, Node endNode, RelationshipType type) {
        Exception e22;
        boolean releaseFailed2;
        RelationshipProxy relationshipProxy;
        boolean success;
        boolean secondNodeTaken;
        RelationshipImpl rel;
        NodeImpl secondNode;
        block19: {
            int startNodeId;
            NodeImpl firstNode;
            if (startNode == null || endNode == null || type == null) {
                throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
            }
            if (!this.relTypeHolder.isValidRelationshipType(type)) {
                this.relTypeHolder.addValidRelationshipType(type.name(), true);
            }
            if ((firstNode = this.getLightNode(startNodeId = (int)startNode.getId())) == null) {
                this.setRollbackOnly();
                throw new NotFoundException("First node[" + startNode.getId() + "] deleted");
            }
            int endNodeId = (int)endNode.getId();
            secondNode = this.getLightNode(endNodeId);
            if (secondNode == null) {
                this.setRollbackOnly();
                throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
            }
            int id = this.idGenerator.nextId(Relationship.class);
            rel = new RelationshipImpl(id, startNodeId, endNodeId, type, true);
            boolean firstNodeTaken = false;
            secondNodeTaken = false;
            this.acquireLock(rel, LockType.WRITE);
            success = false;
            try {
                this.acquireLock(firstNode, LockType.WRITE);
                firstNodeTaken = true;
                this.acquireLock(secondNode, LockType.WRITE);
                secondNodeTaken = true;
                int typeId = this.getRelationshipTypeIdFor(type);
                this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
                firstNode.addRelationship(this, type, id);
                secondNode.addRelationship(this, type, id);
                this.relCache.put((int)rel.getId(), rel);
                success = true;
                relationshipProxy = new RelationshipProxy(id, this);
                Object var16_15 = null;
                releaseFailed2 = false;
                if (!firstNodeTaken) break block19;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var16_16 = null;
                boolean releaseFailed2 = false;
                if (firstNodeTaken) {
                    try {
                        this.releaseLock(firstNode, LockType.WRITE);
                    }
                    catch (Exception e22) {
                        releaseFailed2 = true;
                        e22.printStackTrace();
                        log.severe("Failed to release lock");
                    }
                }
                if (secondNodeTaken) {
                    try {
                        this.releaseLock(secondNode, LockType.WRITE);
                    }
                    catch (Exception e22) {
                        releaseFailed2 = true;
                        e22.printStackTrace();
                        log.severe("Failed to release lock");
                    }
                }
                this.releaseLock(rel, LockType.WRITE);
                if (!success) {
                    this.setRollbackOnly();
                }
                if (releaseFailed2) {
                    throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
                }
                throw throwable;
            }
            try {
                this.releaseLock(firstNode, LockType.WRITE);
            }
            catch (Exception e22) {
                releaseFailed2 = true;
                e22.printStackTrace();
                log.severe("Failed to release lock");
            }
        }
        if (secondNodeTaken) {
            try {
                this.releaseLock(secondNode, LockType.WRITE);
            }
            catch (Exception e22) {
                releaseFailed2 = true;
                e22.printStackTrace();
                log.severe("Failed to release lock");
            }
        }
        this.releaseLock(rel, LockType.WRITE);
        if (!success) {
            this.setRollbackOnly();
        }
        if (releaseFailed2) {
            throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
        }
        return relationshipProxy;
    }

    private ReentrantLock lockId(int id) {
        int stripe = id / 32768 % 32;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.loadLocks[stripe];
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNodeById(int nodeId) throws NotFoundException {
        ReentrantLock loadLock;
        NodeImpl node;
        block5: {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                return new NodeProxy(nodeId, this);
            }
            loadLock = this.lockId(nodeId);
            try {
                if (this.nodeCache.get(nodeId) == null) break block5;
                NodeProxy nodeProxy = new NodeProxy(nodeId, this);
                Object var6_6 = null;
                loadLock.unlock();
                return nodeProxy;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                loadLock.unlock();
                throw throwable;
            }
        }
        if (!this.persistenceManager.loadLightNode(nodeId)) {
            throw new NotFoundException("Node[" + nodeId + "]");
        }
        node = new NodeImpl(nodeId);
        this.nodeCache.put(nodeId, node);
        NodeProxy nodeProxy = new NodeProxy(nodeId, this);
        Object var6_7 = null;
        loadLock.unlock();
        return nodeProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getLightNode(int nodeId) {
        ReentrantLock loadLock;
        NodeImpl node;
        block6: {
            block5: {
                node = this.nodeCache.get(nodeId);
                if (node != null) {
                    return node;
                }
                loadLock = this.lockId(nodeId);
                try {
                    node = this.nodeCache.get(nodeId);
                    if (node == null) break block5;
                    NodeImpl nodeImpl = node;
                    Object var6_7 = null;
                    loadLock.unlock();
                    return nodeImpl;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    loadLock.unlock();
                    throw throwable;
                }
            }
            if (this.persistenceManager.loadLightNode(nodeId)) break block6;
            NodeImpl nodeImpl = null;
            Object var6_8 = null;
            loadLock.unlock();
            return nodeImpl;
        }
        node = new NodeImpl(nodeId);
        this.nodeCache.put(nodeId, node);
        NodeImpl nodeImpl = node;
        Object var6_9 = null;
        loadLock.unlock();
        return nodeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getNodeForProxy(int nodeId) {
        ReentrantLock loadLock;
        NodeImpl node;
        block5: {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                return node;
            }
            loadLock = this.lockId(nodeId);
            try {
                node = this.nodeCache.get(nodeId);
                if (node == null) break block5;
                NodeImpl nodeImpl = node;
                Object var6_6 = null;
                loadLock.unlock();
                return nodeImpl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                loadLock.unlock();
                throw throwable;
            }
        }
        if (!this.persistenceManager.loadLightNode(nodeId)) {
            throw new NotFoundException("Node[" + nodeId + "] not found.");
        }
        node = new NodeImpl(nodeId);
        this.nodeCache.put(nodeId, node);
        NodeImpl nodeImpl = node;
        Object var6_7 = null;
        loadLock.unlock();
        return nodeImpl;
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    void setReferenceNodeId(int nodeId) {
        this.referenceNodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationshipById(int relId) throws NotFoundException {
        ReentrantLock loadLock;
        RelationshipImpl relationship;
        block6: {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                return new RelationshipProxy(relId, this);
            }
            loadLock = this.lockId(relId);
            try {
                relationship = this.relCache.get(relId);
                if (relationship == null) break block6;
                RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
                Object var11_6 = null;
                loadLock.unlock();
                return relationshipProxy;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                loadLock.unlock();
                throw throwable;
            }
        }
        RelationshipData data = this.persistenceManager.loadLightRelationship(relId);
        if (data == null) {
            throw new NotFoundException("Relationship[" + relId + "]");
        }
        int typeId = data.relationshipType();
        RelationshipType type = this.getRelationshipTypeById(typeId);
        if (type == null) {
            throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
        }
        int startNodeId = data.firstNode();
        int endNodeId = data.secondNode();
        relationship = new RelationshipImpl(relId, startNodeId, endNodeId, type, false);
        this.relCache.put(relId, relationship);
        RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
        Object var11_7 = null;
        loadLock.unlock();
        return relationshipProxy;
    }

    RelationshipType getRelationshipTypeById(int id) {
        return this.relTypeHolder.getRelationshipType(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationshipImpl getRelForProxy(int relId) {
        ReentrantLock loadLock;
        RelationshipImpl relationship;
        block6: {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                return relationship;
            }
            loadLock = this.lockId(relId);
            try {
                relationship = this.relCache.get(relId);
                if (relationship == null) break block6;
                RelationshipImpl relationshipImpl = relationship;
                Object var9_6 = null;
                loadLock.unlock();
                return relationshipImpl;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                loadLock.unlock();
                throw throwable;
            }
        }
        RelationshipData data = this.persistenceManager.loadLightRelationship(relId);
        if (data == null) {
            throw new NotFoundException("Relationship[" + relId + "] not found.");
        }
        int typeId = data.relationshipType();
        RelationshipType type = this.getRelationshipTypeById(typeId);
        if (type == null) {
            throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
        }
        relationship = new RelationshipImpl(relId, data.firstNode(), data.secondNode(), type, false);
        this.relCache.put(relId, relationship);
        RelationshipImpl relationshipImpl = relationship;
        Object var9_7 = null;
        loadLock.unlock();
        return relationshipImpl;
    }

    public void removeNodeFromCache(int nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(int id) {
        this.relCache.remove(id);
    }

    Object loadPropertyValue(int id) {
        return this.persistenceManager.loadPropertyValue(id);
    }

    RelationshipChainPosition getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition((int)node.getId());
    }

    Pair<ArrayMap<String, IntArray>, Map<Integer, RelationshipImpl>> getMoreRelationships(NodeImpl node) {
        int nodeId = (int)node.getId();
        RelationshipChainPosition position = node.getRelChainPosition();
        Iterable<RelationshipData> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<String, IntArray> newRelationshipMap = new ArrayMap<String, IntArray>();
        HashMap<Integer, RelationshipImpl> relsMap = new HashMap<Integer, RelationshipImpl>(150);
        for (RelationshipData rel : rels) {
            int relId = rel.getId();
            RelationshipImpl relImpl = this.relCache.get(relId);
            RelationshipType type = null;
            if (relImpl == null) {
                type = this.getRelationshipTypeById(rel.relationshipType());
                assert (type != null);
                relImpl = new RelationshipImpl(relId, rel.firstNode(), rel.secondNode(), type, false);
                relsMap.put(relId, relImpl);
            } else {
                type = relImpl.getType();
            }
            IntArray relationshipSet = (IntArray)newRelationshipMap.get(type.name());
            if (relationshipSet == null) {
                relationshipSet = new IntArray();
                newRelationshipMap.put(type.name(), relationshipSet);
            }
            relationshipSet.add(relId);
        }
        return new Pair<ArrayMap<String, IntArray>, Map<Integer, RelationshipImpl>>(newRelationshipMap, relsMap);
    }

    void putAllInRelCache(Map<Integer, RelationshipImpl> map) {
        this.relCache.putAll(map);
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node, boolean light) {
        return this.persistenceManager.loadNodeProperties((int)node.getId(), light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship, boolean light) {
        return this.persistenceManager.loadRelProperties((int)relationship.getId(), light);
    }

    public int getNodeCacheSize() {
        return this.nodeCache.size();
    }

    public int getRelationshipCacheSize() {
        return this.relCache.size();
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.log(Level.FINE, "Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            log.log(Level.SEVERE, "Failed to set transaction rollback only", se);
        }
    }

    void acquireLock(Primitive resource, LockType lockType) {
        if (lockType == LockType.READ) {
            this.lockManager.getReadLock(resource);
        } else if (lockType == LockType.WRITE) {
            this.lockManager.getWriteLock(resource);
        } else {
            throw new LockException("Unknown lock type: " + (Object)((Object)lockType));
        }
    }

    void releaseLock(Primitive resource, LockType lockType) {
        if (lockType == LockType.READ) {
            this.lockManager.releaseReadLock(resource);
        } else if (lockType == LockType.WRITE) {
            this.lockReleaser.addLockToTransaction(resource, lockType);
        } else {
            throw new LockException("Unknown lock type: " + (Object)((Object)lockType));
        }
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeRelType(id);
    }

    void addPropertyIndexes(PropertyIndexData[] propertyIndexes) {
        this.propertyIndexManager.addPropertyIndexes(propertyIndexes);
    }

    void setHasAllpropertyIndexes(boolean hasAll) {
        this.propertyIndexManager.setHasAll(hasAll);
    }

    void clearPropertyIndexes() {
        this.propertyIndexManager.clear();
    }

    PropertyIndex getIndexFor(int keyId) {
        return this.propertyIndexManager.getIndexFor(keyId);
    }

    Iterable<PropertyIndex> index(String key) {
        return this.propertyIndexManager.index(key);
    }

    boolean hasAllPropertyIndexes() {
        return this.propertyIndexManager.hasAll();
    }

    boolean hasIndexFor(int keyId) {
        return this.propertyIndexManager.hasIndexFor(keyId);
    }

    PropertyIndex createPropertyIndex(String key) {
        return this.propertyIndexManager.createPropertyIndex(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdFor(type);
    }

    void addRawRelationshipTypes(RelationshipTypeData[] relTypes) {
        this.relTypeHolder.addRawRelationshipTypes(relTypes);
    }

    Iterable<RelationshipType> getRelationshipTypes() {
        return this.relTypeHolder.getRelationshipTypes();
    }

    ArrayMap<Integer, PropertyData> deleteNode(NodeImpl node) {
        int nodeId = (int)node.getId();
        this.deletePrimitive(node);
        return this.persistenceManager.nodeDelete(nodeId);
    }

    int nodeAddProperty(NodeImpl node, PropertyIndex index, Object value) {
        int nodeId = (int)node.getId();
        return this.persistenceManager.nodeAddProperty(nodeId, index, value);
    }

    void nodeChangeProperty(NodeImpl node, int propertyId, Object value) {
        int nodeId = (int)node.getId();
        this.persistenceManager.nodeChangeProperty(nodeId, propertyId, value);
    }

    void nodeRemoveProperty(NodeImpl node, int propertyId) {
        int nodeId = (int)node.getId();
        this.persistenceManager.nodeRemoveProperty(nodeId, propertyId);
    }

    ArrayMap<Integer, PropertyData> deleteRelationship(RelationshipImpl rel) {
        int relId = (int)rel.getId();
        this.deletePrimitive(rel);
        return this.persistenceManager.relDelete(relId);
    }

    int relAddProperty(RelationshipImpl rel, PropertyIndex index, Object value) {
        int relId = (int)rel.getId();
        return this.persistenceManager.relAddProperty(relId, index, value);
    }

    void relChangeProperty(RelationshipImpl rel, int propertyId, Object value) {
        int relId = (int)rel.getId();
        this.persistenceManager.relChangeProperty(relId, propertyId, value);
    }

    void relRemoveProperty(RelationshipImpl rel, int propertyId) {
        int relId = (int)rel.getId();
        this.persistenceManager.relRemoveProperty(relId, propertyId);
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type);
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type, boolean create) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type, create);
    }

    public ArrayMap<String, IntArray> getCowRelationshipAddMap(NodeImpl node) {
        return this.lockReleaser.getCowRelationshipAddMap(node);
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String string) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string);
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String string, boolean create) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string, create);
    }

    public NodeImpl getNodeIfCached(int nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipImpl getRelIfCached(int nodeId) {
        return this.relCache.get(nodeId);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive);
    }

    private void deletePrimitive(Primitive primitive) {
        this.lockReleaser.deletePrimitive(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyAddMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyAddMap(primitive, create);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive, create);
    }

    LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    void addRelationshipType(RelationshipTypeData type) {
        this.relTypeHolder.addRawRelationshipType(type);
    }

    void addPropertyIndex(PropertyIndexData index) {
        this.propertyIndexManager.addPropertyIndex(index);
    }

    public TransactionData getTransactionData() {
        return this.lockReleaser.getTransactionData();
    }

    IntArray getCreatedNodes() {
        return this.persistenceManager.getCreatedNodes();
    }

    boolean nodeCreated(int nodeId) {
        return this.persistenceManager.isNodeCreated(nodeId);
    }

    boolean relCreated(int relId) {
        return this.persistenceManager.isRelationshipCreated(relId);
    }

    public String getKeyForProperty(int propertyId) {
        int keyId = this.persistenceManager.getKeyIdForProperty(propertyId);
        return this.propertyIndexManager.getIndexFor(keyId).getKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        weak(false, "weak reference cache"){

            @Override
            Cache<Integer, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new WeakLruCache<Integer, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Integer, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new WeakLruCache<Integer, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        }
        ,
        soft(false, "soft reference cache"){

            @Override
            Cache<Integer, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new SoftLruCache<Integer, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Integer, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new SoftLruCache<Integer, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        }
        ,
        old(true, "lru cache"){

            @Override
            Cache<Integer, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new LruCache<Integer, NodeImpl>(CacheType.NODE_CACHE_NAME, 1500, cacheManager);
            }

            @Override
            Cache<Integer, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new LruCache<Integer, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME, 3500, cacheManager);
            }
        }
        ,
        none(false, "no cache"){

            @Override
            Cache<Integer, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new NoCache<Integer, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Integer, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new NoCache<Integer, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        };

        private static final String NODE_CACHE_NAME = "NodeCache";
        private static final String RELATIONSHIP_CACHE_NAME = "RelationshipCache";
        final boolean needsCacheManagerRegistration;
        private final String description;

        private CacheType(boolean needsCacheManagerRegistration, String description) {
            this.needsCacheManagerRegistration = needsCacheManagerRegistration;
            this.description = description;
        }

        abstract Cache<Integer, NodeImpl> node(AdaptiveCacheManager var1);

        abstract Cache<Integer, RelationshipImpl> relationship(AdaptiveCacheManager var1);

        public String getDescription() {
            return this.description;
        }
    }
}

