/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedReadOnlyGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService {
    private static Map<String, String> readOnlyParams = new HashMap<String, String>();
    private final EmbeddedGraphDbImpl graphDbImpl;

    public EmbeddedReadOnlyGraphDatabase(String storeDir) {
        this(storeDir, readOnlyParams);
    }

    public EmbeddedReadOnlyGraphDatabase(String storeDir, Map<String, String> params) {
        params.put("read_only", "true");
        this.graphDbImpl = new EmbeddedGraphDbImpl(storeDir, params, this);
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDbImpl.loadConfigurations(file);
    }

    @Override
    public Node createNode() {
        return this.graphDbImpl.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.graphDbImpl.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.graphDbImpl.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.graphDbImpl.getReferenceNode();
    }

    @Override
    public void shutdown() {
        this.graphDbImpl.shutdown();
    }

    @Override
    public boolean enableRemoteShell() {
        return this.graphDbImpl.enableRemoteShell();
    }

    @Override
    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.graphDbImpl.enableRemoteShell(initialProperties);
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.graphDbImpl.getRelationshipTypes();
    }

    @Override
    public Transaction beginTx() {
        return this.graphDbImpl.beginTx();
    }

    @Override
    public Config getConfig() {
        return this.graphDbImpl.getConfig();
    }

    @Override
    public <T> T getManagementBean(Class<T> type) {
        return this.graphDbImpl.getManagementBean(type);
    }

    public String toString() {
        return super.toString() + " [" + this.graphDbImpl.getStoreDir() + "]";
    }

    public String getStoreDir() {
        return this.graphDbImpl.getStoreDir();
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.graphDbImpl.getAllNodes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    static {
        readOnlyParams.put("read_only", "true");
    }
}

