/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.core.GraphDbModule;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.management.Description;
import org.neo4j.kernel.impl.persistence.IdGeneratorModule;
import org.neo4j.kernel.impl.persistence.PersistenceModule;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    static final String NIO_NEO_DB_CLASS = "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource";
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    static final String LUCENE_DS_CLASS = "org.neo4j.index.lucene.LuceneDataSource";
    static final String LUCENE_FULLTEXT_DS_CLASS = "org.neo4j.index.lucene.LuceneFulltextDataSource";
    @Description(value="Tell Neo4j to use memory mapped buffers for accessing the native storage layer")
    public static final String USE_MEMORY_MAPPED_BUFFERS = "use_memory_mapped_buffers";
    @Description(value="Print out the effective Neo4j configuration after startup")
    public static final String DUMP_CONFIGURATION = "dump_configuration";
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database")
    public static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";
    @Description(value="Only allow read operations from this Neo4j instance")
    public static final String READ_ONLY = "read_only";
    @Description(value="Relative path for where the Neo4j storage directory is located")
    public static final String STORAGE_DIRECTORY = "store_dir";
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    public static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    @Description(value="The size to allocate for memory mapping the node store")
    public static final String NODE_STORE_MMAP_SIZE = "neostore.nodestore.db.mapped_memory";
    @Description(value="The size to allocate for memory mapping the array property store")
    public static final String ARRAY_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.arrays.mapped_memory";
    @Description(value="The size to allocate for memory mapping the store for property key strings")
    public static final String PROPERTY_INDEX_KEY_STORE_MMAP_SIZE = "neostore.propertystore.db.index.keys.mapped_memory";
    @Description(value="The size to allocate for memory mapping the store for property key indexes")
    public static final String PROPERTY_INDEX_STORE_MMAP_SIZE = "neostore.propertystore.db.index.mapped_memory";
    @Description(value="The size to allocate for memory mapping the property value store")
    public static final String PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.mapped_memory";
    @Description(value="The size to allocate for memory mapping the string property store")
    public static final String STRING_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.strings.mapped_memory";
    @Description(value="The size to allocate for memory mapping the relationship store")
    public static final String RELATIONSHIP_STORE_MMAP_SIZE = "neostore.relationshipstore.db.mapped_memory";
    @Description(value="Relative path for where the Neo4j logical log is located")
    public static final String LOGICAL_LOG = "logical_log";
    @Description(value="Relative path for where the Neo4j storage information file is located")
    public static final String NEO_STORE = "neo_store";
    @Description(value="The type of cache to use for nodes and relationships, one of [weak, soft, none]")
    public static final String CACHE_TYPE = "cache_type";
    private AdaptiveCacheManager cacheManager;
    private TxModule txModule;
    private LockManager lockManager;
    private LockReleaser lockReleaser;
    private PersistenceModule persistenceModule;
    private boolean create = false;
    private String persistenceSourceName;
    private IdGeneratorModule idGeneratorModule;
    private GraphDbModule graphDbModule;
    private String storeDir;
    private final Map<Object, Object> params;
    private final boolean readOnly;
    private final boolean backupSlave;

    Config(GraphDatabaseService graphDb, String storeDir, Map<Object, Object> params, KernelPanicEventGenerator kpe) {
        this.storeDir = storeDir;
        this.params = params;
        String readOnlyStr = (String)params.get(READ_ONLY);
        this.readOnly = readOnlyStr != null && readOnlyStr.toLowerCase().equals("true");
        String backupSlaveStr = (String)params.get("backup_slave");
        this.backupSlave = backupSlaveStr != null && backupSlaveStr.toLowerCase().equals("true");
        params.put(READ_ONLY, this.readOnly);
        this.cacheManager = new AdaptiveCacheManager();
        this.txModule = !this.readOnly ? new TxModule(this.storeDir, kpe) : new TxModule(true, kpe);
        this.lockManager = new LockManager(this.txModule.getTxManager());
        this.lockReleaser = new LockReleaser(this.lockManager, this.txModule.getTxManager());
        this.persistenceModule = new PersistenceModule();
        this.idGeneratorModule = new IdGeneratorModule();
        this.graphDbModule = new GraphDbModule(graphDb, this.cacheManager, this.lockManager, this.txModule.getTxManager(), this.idGeneratorModule.getIdGenerator(), this.readOnly);
    }

    void setPersistenceSource(String name, boolean create) {
        this.persistenceSourceName = name;
        this.create = create;
    }

    String getPersistenceSource() {
        return this.persistenceSourceName;
    }

    boolean getCreatePersistenceSource() {
        return this.create;
    }

    public TxModule getTxModule() {
        return this.txModule;
    }

    public GraphDbModule getGraphDbModule() {
        return this.graphDbModule;
    }

    public PersistenceModule getPersistenceModule() {
        return this.persistenceModule;
    }

    IdGeneratorModule getIdGeneratorModule() {
        return this.idGeneratorModule;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    public Map<Object, Object> getParams() {
        return this.params;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }
}

