/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscriberProbe;
import org.neo4j.values.AnyValue;

public class ProbingQuerySubscriber
implements QuerySubscriber {
    private final QuerySubscriberProbe probe;

    public ProbingQuerySubscriber(QuerySubscriberProbe probe) {
        this.probe = probe;
    }

    public ProbingQuerySubscriber() {
        this.probe = null;
    }

    public void onResult(int numberOfFields) {
        if (this.probe != null) {
            this.probe.onResult(numberOfFields);
        }
    }

    public void onRecord() {
        if (this.probe != null) {
            this.probe.onRecord();
        }
    }

    public void onField(int offset, AnyValue value) {
        if (this.probe != null) {
            this.probe.onField(offset, value);
        }
    }

    public void onRecordCompleted() {
        if (this.probe != null) {
            this.probe.onRecordCompleted();
        }
    }

    public void onError(Throwable throwable) {
        if (this.probe != null) {
            this.probe.onError(throwable);
        }
    }

    public void onResultCompleted(QueryStatistics statistics) {
        if (this.probe != null) {
            this.probe.onResultCompleted(statistics);
        }
    }
}

