/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.event.PropertyEntryImpl;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;
import org.neo4j.values.storable.Values;

class ExpectedTransactionData {
    final Set<Node> expectedCreatedNodes = new HashSet<Node>();
    final Set<Relationship> expectedCreatedRelationships = new HashSet<Relationship>();
    final Set<Node> expectedDeletedNodes = new HashSet<Node>();
    final Set<Relationship> expectedDeletedRelationships = new HashSet<Relationship>();
    private final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = new AutoCreatingHashMap<Node, Map<Node, Map<String, PropertyEntryImpl<Node>>>>(AutoCreatingHashMap.nested(AutoCreatingHashMap.dontCreate()));
    private final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = new AutoCreatingHashMap<Relationship, Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>>>(AutoCreatingHashMap.nested(AutoCreatingHashMap.dontCreate()));
    private final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = new AutoCreatingHashMap<Node, Map<Node, Map<String, PropertyEntryImpl<Node>>>>(AutoCreatingHashMap.nested(AutoCreatingHashMap.dontCreate()));
    private final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = new AutoCreatingHashMap<Relationship, Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>>>(AutoCreatingHashMap.nested(AutoCreatingHashMap.dontCreate()));
    private final Map<Node, Set<String>> expectedAssignedLabels = new AutoCreatingHashMap<Node, Set<Set<String>>>(AutoCreatingHashMap.valuesOfTypeHashSet());
    private final Map<Node, Set<String>> expectedRemovedLabels = new AutoCreatingHashMap<Node, Set<Set<String>>>(AutoCreatingHashMap.valuesOfTypeHashSet());
    private final boolean ignoreAdditionalData;

    ExpectedTransactionData(boolean ignoreAdditionalData) {
        this.ignoreAdditionalData = ignoreAdditionalData;
    }

    ExpectedTransactionData() {
        this(false);
    }

    void clear() {
        this.expectedAssignedNodeProperties.clear();
        this.expectedAssignedRelationshipProperties.clear();
        this.expectedCreatedNodes.clear();
        this.expectedCreatedRelationships.clear();
        this.expectedDeletedNodes.clear();
        this.expectedDeletedRelationships.clear();
        this.expectedRemovedNodeProperties.clear();
        this.expectedRemovedRelationshipProperties.clear();
        this.expectedAssignedLabels.clear();
        this.expectedRemovedLabels.clear();
    }

    void createdNode(Node node) {
        this.expectedCreatedNodes.add(node);
    }

    void deletedNode(Node node) {
        if (!this.expectedCreatedNodes.remove(node)) {
            this.expectedDeletedNodes.add(node);
        }
        this.expectedAssignedNodeProperties.remove(node);
        this.expectedAssignedLabels.remove(node);
        this.expectedRemovedNodeProperties.remove(node);
        this.expectedRemovedLabels.remove(node);
    }

    void createdRelationship(Relationship relationship) {
        this.expectedCreatedRelationships.add(relationship);
    }

    void deletedRelationship(Relationship relationship) {
        if (!this.expectedCreatedRelationships.remove(relationship)) {
            this.expectedDeletedRelationships.add(relationship);
        }
        this.expectedAssignedRelationshipProperties.remove(relationship);
        this.expectedRemovedRelationshipProperties.remove(relationship);
    }

    void assignedProperty(Node node, String key, Object value, Object valueBeforeTx) {
        if (ExpectedTransactionData.isDifferent(value, valueBeforeTx = ExpectedTransactionData.removeProperty(this.expectedRemovedNodeProperties, node, key, valueBeforeTx))) {
            Map<String, PropertyEntryImpl<Node>> map;
            PropertyEntryImpl<Node> prev = (map = this.expectedAssignedNodeProperties.get(node)).get(key);
            map.put(key, ExpectedTransactionData.property(node, key, value, prev != null ? prev.previouslyCommittedValue() : valueBeforeTx));
        }
    }

    void assignedProperty(Relationship rel, String key, Object value, Object valueBeforeTx) {
        if (ExpectedTransactionData.isDifferent(value, valueBeforeTx = ExpectedTransactionData.removeProperty(this.expectedRemovedRelationshipProperties, rel, key, valueBeforeTx))) {
            Map<String, PropertyEntryImpl<Relationship>> map;
            PropertyEntryImpl<Relationship> prev = (map = this.expectedAssignedRelationshipProperties.get(rel)).get(key);
            map.put(key, ExpectedTransactionData.property(rel, key, value, prev != null ? prev.previouslyCommittedValue() : valueBeforeTx));
        }
    }

    void assignedLabel(Node node, Label label) {
        if (ExpectedTransactionData.removeLabel(this.expectedRemovedLabels, node, label)) {
            this.expectedAssignedLabels.get(node).add(label.name());
        }
    }

    void removedLabel(Node node, Label label) {
        if (ExpectedTransactionData.removeLabel(this.expectedAssignedLabels, node, label)) {
            this.expectedRemovedLabels.get(node).add(label.name());
        }
    }

    private static boolean removeLabel(Map<Node, Set<String>> map, Node node, Label label) {
        if (map.containsKey(node)) {
            Set<String> set = map.get(node);
            if (!set.remove(label.name())) {
                return true;
            }
            if (set.isEmpty()) {
                map.remove(node);
            }
        }
        return false;
    }

    void removedProperty(Node node, String key, Object valueBeforeTx) {
        if ((valueBeforeTx = ExpectedTransactionData.removeProperty(this.expectedAssignedNodeProperties, node, key, valueBeforeTx)) != null) {
            this.expectedRemovedNodeProperties.get(node).put(key, ExpectedTransactionData.property(node, key, null, valueBeforeTx));
        }
    }

    void removedProperty(Relationship rel, String key, Object valueBeforeTx) {
        if ((valueBeforeTx = ExpectedTransactionData.removeProperty(this.expectedAssignedRelationshipProperties, rel, key, valueBeforeTx)) != null) {
            this.expectedRemovedRelationshipProperties.get(rel).put(key, ExpectedTransactionData.property(rel, key, null, valueBeforeTx));
        }
    }

    private static <E> Object removeProperty(Map<E, Map<String, PropertyEntryImpl<E>>> map, E entity, String key, Object valueBeforeTx) {
        if (map.containsKey(entity)) {
            Map<String, PropertyEntryImpl<E>> inner = map.get(entity);
            PropertyEntryImpl<E> entry = inner.remove(key);
            if (entry == null) {
                return valueBeforeTx;
            }
            if (inner.isEmpty()) {
                map.remove(entity);
            }
            if (entry.previouslyCommittedValue() != null) {
                return entry.previouslyCommittedValue();
            }
            return null;
        }
        return valueBeforeTx;
    }

    private static <E> PropertyEntryImpl<E> property(E entity, String key, Object value, Object valueBeforeTx) {
        return new PropertyEntryImpl<E>(entity, key, value, valueBeforeTx);
    }

    void compareTo(TransactionData data) {
        HashSet<Node> expectedCreatedNodes = new HashSet<Node>(this.expectedCreatedNodes);
        HashSet<Relationship> expectedCreatedRelationships = new HashSet<Relationship>(this.expectedCreatedRelationships);
        HashSet<Node> expectedDeletedNodes = new HashSet<Node>(this.expectedDeletedNodes);
        HashSet<Relationship> expectedDeletedRelationships = new HashSet<Relationship>(this.expectedDeletedRelationships);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = ExpectedTransactionData.clone(this.expectedAssignedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = ExpectedTransactionData.clone(this.expectedAssignedRelationshipProperties);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = ExpectedTransactionData.clone(this.expectedRemovedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = ExpectedTransactionData.clone(this.expectedRemovedRelationshipProperties);
        Map<Node, Set<String>> expectedAssignedLabels = ExpectedTransactionData.cloneLabelData(this.expectedAssignedLabels);
        Map<Node, Set<String>> expectedRemovedLabels = ExpectedTransactionData.cloneLabelData(this.expectedRemovedLabels);
        for (Node node : data.createdNodes()) {
            Assertions.assertTrue((boolean)expectedCreatedNodes.remove(node));
            Assertions.assertFalse((boolean)data.isDeleted(node));
        }
        Assertions.assertTrue((boolean)expectedCreatedNodes.isEmpty(), (String)("Expected some created nodes that weren't seen: " + expectedCreatedNodes));
        for (Relationship rel : data.createdRelationships()) {
            Assertions.assertTrue((boolean)expectedCreatedRelationships.remove(rel));
            Assertions.assertFalse((boolean)data.isDeleted(rel));
        }
        Assertions.assertTrue((boolean)expectedCreatedRelationships.isEmpty(), (String)("Expected created relationships not encountered " + expectedCreatedRelationships));
        for (Node node : data.deletedNodes()) {
            Assertions.assertTrue((boolean)expectedDeletedNodes.remove(node), (String)("Unexpected deleted node " + node));
            Assertions.assertTrue((boolean)data.isDeleted(node));
        }
        Assertions.assertTrue((boolean)expectedDeletedNodes.isEmpty(), (String)("Expected deleted nodes: " + expectedDeletedNodes));
        for (Relationship rel : data.deletedRelationships()) {
            Assertions.assertTrue((boolean)expectedDeletedRelationships.remove(rel));
            Assertions.assertTrue((boolean)data.isDeleted(rel));
        }
        Assertions.assertTrue((boolean)expectedDeletedRelationships.isEmpty(), (String)("Expected deleted relationships not encountered " + expectedDeletedRelationships));
        for (PropertyEntry entry : data.assignedNodeProperties()) {
            this.checkAssigned(expectedAssignedNodeProperties, entry);
            Assertions.assertFalse((boolean)data.isDeleted((Node)entry.entity()));
        }
        Assertions.assertTrue((boolean)expectedAssignedNodeProperties.isEmpty(), (String)("Expected assigned node properties not encountered " + expectedAssignedNodeProperties));
        for (PropertyEntry entry : data.assignedRelationshipProperties()) {
            this.checkAssigned(expectedAssignedRelationshipProperties, entry);
            Assertions.assertFalse((boolean)data.isDeleted((Relationship)entry.entity()));
        }
        Assertions.assertTrue((boolean)expectedAssignedRelationshipProperties.isEmpty(), (String)("Expected assigned relationship properties not encountered " + expectedAssignedRelationshipProperties));
        for (PropertyEntry entry : data.removedNodeProperties()) {
            this.checkRemoved(expectedRemovedNodeProperties, entry);
        }
        Assertions.assertTrue((boolean)expectedRemovedNodeProperties.isEmpty(), (String)("Expected removed node properties not encountered " + expectedRemovedNodeProperties));
        for (PropertyEntry entry : data.removedRelationshipProperties()) {
            this.checkRemoved(expectedRemovedRelationshipProperties, entry);
        }
        Assertions.assertTrue((boolean)expectedRemovedRelationshipProperties.isEmpty(), (String)("Expected removed relationship properties not encountered " + expectedRemovedRelationshipProperties));
        for (PropertyEntry entry : data.assignedLabels()) {
            this.check(expectedAssignedLabels, (LabelEntry)entry);
        }
        Assertions.assertTrue((boolean)expectedAssignedLabels.isEmpty(), (String)("Expected assigned labels not encountered " + expectedAssignedLabels));
        for (PropertyEntry entry : data.removedLabels()) {
            this.check(expectedRemovedLabels, (LabelEntry)entry);
        }
        Assertions.assertTrue((boolean)expectedRemovedLabels.isEmpty(), (String)("Expected removed labels not encountered " + expectedRemovedLabels));
    }

    private static Map<Node, Set<String>> cloneLabelData(Map<Node, Set<String>> map) {
        HashMap<Node, Set<String>> clone = new HashMap<Node, Set<String>>();
        for (Map.Entry<Node, Set<String>> entry : map.entrySet()) {
            clone.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return clone;
    }

    private void check(Map<Node, Set<String>> expected, LabelEntry entry) {
        Node node = entry.node();
        String labelName = entry.label().name();
        boolean hasEntity = expected.containsKey(node);
        if (!hasEntity && this.ignoreAdditionalData) {
            return;
        }
        Assertions.assertTrue((boolean)hasEntity, (String)("Unexpected node " + node));
        Set<String> labels = expected.get(node);
        boolean hasLabel = labels.remove(labelName);
        if (!hasLabel && this.ignoreAdditionalData) {
            return;
        }
        Assertions.assertTrue((boolean)hasLabel, (String)("Unexpected label " + labelName + " for " + node));
        if (labels.isEmpty()) {
            expected.remove(node);
        }
    }

    private static <KEY> Map<KEY, Map<String, PropertyEntryImpl<KEY>>> clone(Map<KEY, Map<String, PropertyEntryImpl<KEY>>> map) {
        HashMap<KEY, HashMap<String, PropertyEntryImpl<KEY>>> result = new HashMap<KEY, HashMap<String, PropertyEntryImpl<KEY>>>();
        for (Map.Entry<KEY, Map<String, PropertyEntryImpl<KEY>>> entry : map.entrySet()) {
            result.put(entry.getKey(), new HashMap<String, PropertyEntryImpl<KEY>>(entry.getValue()));
        }
        return result;
    }

    private <T> void checkAssigned(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        PropertyEntryImpl<T> expected = this.fetchExpectedPropertyEntry(map, entry);
        if (expected != null) {
            expected.compareToAssigned(entry);
        }
    }

    private <T> void checkRemoved(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        PropertyEntryImpl<T> expected = this.fetchExpectedPropertyEntry(map, entry);
        if (expected != null) {
            expected.compareToRemoved(entry);
        }
    }

    private <T> PropertyEntryImpl<T> fetchExpectedPropertyEntry(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        Object entity = entry.entity();
        boolean hasEntity = map.containsKey(entity);
        if (this.ignoreAdditionalData && !hasEntity) {
            return null;
        }
        Assertions.assertTrue((boolean)hasEntity, (String)("Unexpected entity " + entry));
        Map<String, PropertyEntryImpl<T>> innerMap = map.get(entity);
        PropertyEntryImpl<T> expectedEntry = innerMap.remove(entry.key());
        if (expectedEntry == null && this.ignoreAdditionalData) {
            return null;
        }
        Assertions.assertNotNull(expectedEntry, (String)("Unexpected property entry " + entry));
        if (innerMap.isEmpty()) {
            map.remove(entity);
        }
        return expectedEntry;
    }

    private static boolean isDifferent(Object value, Object valueBeforeTx) {
        return !Values.of((Object)value).equalTo((Object)Values.of((Object)valueBeforeTx));
    }
}

