/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.lock.ActiveLock;

public class TestKernelTransactionHandle
implements KernelTransactionHandle {
    private static final String USER_TRANSACTION_NAME_PREFIX = "transaction-";
    private final KernelTransaction tx;

    public TestKernelTransactionHandle(KernelTransaction tx) {
        this.tx = Objects.requireNonNull(tx);
    }

    public long startTime() {
        return this.tx.startTime();
    }

    public long startTimeNanos() {
        return this.tx.startTimeNanos();
    }

    public TransactionTimeout timeout() {
        return this.tx.timeout();
    }

    public boolean isOpen() {
        return this.tx.isOpen();
    }

    public boolean isClosing() {
        return this.tx.isClosing();
    }

    public boolean isCommitting() {
        return this.tx.isCommitting();
    }

    public boolean isRollingback() {
        return this.tx.isRollingback();
    }

    public boolean markForTermination(Status reason) {
        this.tx.markForTermination(reason);
        return true;
    }

    public AuthSubject subject() {
        return this.tx.subjectOrAnonymous();
    }

    public Map<String, Object> getMetaData() {
        return Collections.emptyMap();
    }

    public Optional<TerminationMark> terminationMark() {
        return this.tx.getTerminationMark();
    }

    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    public long getTransactionSequenceNumber() {
        return this.tx.getTransactionSequenceNumber();
    }

    public String getUserTransactionName() {
        return USER_TRANSACTION_NAME_PREFIX + this.getTransactionSequenceNumber();
    }

    public Optional<ExecutingQuery> executingQuery() {
        throw new UnsupportedOperationException();
    }

    public Stream<ActiveLock> activeLocks() {
        return Stream.empty();
    }

    public TransactionExecutionStatistic transactionStatistic() {
        return TransactionExecutionStatistic.NOT_AVAILABLE;
    }

    public TransactionInitializationTrace transactionInitialisationTrace() {
        return TransactionInitializationTrace.NONE;
    }

    public Optional<ClientConnectionInfo> clientInfo() {
        return Optional.ofNullable(this.tx.clientInfo());
    }

    public boolean isSchemaTransaction() {
        return this.tx.isSchemaTransaction();
    }

    public String getStatusDetails() {
        return this.tx.statusDetails();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestKernelTransactionHandle that = (TestKernelTransactionHandle)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public String toString() {
        return "TestKernelTransactionHandle{tx=" + this.tx + "}";
    }
}

