/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;

public class CountingJobScheduler
implements JobScheduler {
    private final AtomicInteger counter;
    private final JobScheduler delegate;

    public CountingJobScheduler(AtomicInteger counter, JobScheduler delegate) {
        this.counter = counter;
        this.delegate = delegate;
    }

    public void setTopLevelGroupName(String name) {
        this.delegate.setTopLevelGroupName(name);
    }

    public void setParallelism(Group group, int parallelism) {
        this.delegate.setParallelism(group, parallelism);
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
        this.delegate.setThreadFactory(group, threadFactory);
    }

    public CallableExecutor executor(Group group) {
        return this.delegate.executor(group);
    }

    public MonitoredJobExecutor monitoredJobExecutor(Group group) {
        return this.delegate.monitoredJobExecutor(group);
    }

    public ThreadFactory threadFactory(Group group) {
        return this.delegate.threadFactory(group);
    }

    public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, jobMonitoringParams, job);
    }

    public JobHandle<?> schedule(Group group, Runnable job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, job);
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, monitoredJobParams, job);
    }

    public JobHandle<?> schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, runnable, initialDelay, timeUnit);
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        this.counter.incrementAndGet();
        return this.delegate.schedule(group, monitoredJobParams, runnable, initialDelay, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, period, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, monitoredJobParams, runnable, period, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, initialDelay, period, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, monitoredJobParams, runnable, initialDelay, period, timeUnit);
    }

    public Stream<ActiveGroup> activeGroups() {
        return this.delegate.activeGroups();
    }

    public List<MonitoredJobInfo> getMonitoredJobs() {
        return this.delegate.getMonitoredJobs();
    }

    public List<FailedJobRun> getFailedJobRuns() {
        return this.delegate.getFailedJobRuns();
    }

    public void init() throws Exception {
        this.delegate.init();
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() throws Exception {
        this.delegate.stop();
    }

    public void shutdown() throws Exception {
        this.delegate.shutdown();
    }

    public void close() {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

