/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.collection.factory.OnHeapCollectionsFactory;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.readonly.DefaultReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.version.DefaultVersionStorageTracer;
import org.neo4j.io.pagecache.tracing.version.VersionStorageTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;
import org.neo4j.kernel.database.PrivilegeDatabaseReferenceImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.KernelTransactionsStateBehaviour;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.chunk.TransactionRollbackProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.tracer.DefaultDatabaseTracer;
import org.neo4j.kernel.impl.api.transaction.serial.DatabaseSerialGuard;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.ApplyEnrichmentStrategy;
import org.neo4j.storageengine.api.enrichment.EnrichmentMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

class KernelTransactionTestBase {
    protected final ServerIdentity serverIdentity = (ServerIdentity)Mockito.mock(ServerIdentity.class);
    protected final ApplyEnrichmentStrategy enrichmentStrategy = (ApplyEnrichmentStrategy)Mockito.mock(ApplyEnrichmentStrategy.class);
    protected final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class, (Answer)Mockito.RETURNS_MOCKS);
    protected final StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
    protected final MetadataProvider metadataProvider = (MetadataProvider)Mockito.mock(MetadataProvider.class);
    protected final CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
    protected final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    protected final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    protected final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    protected final FakeClock clock = Clocks.fakeClock();
    protected final Pool<KernelTransactionImplementation> txPool = (Pool)Mockito.mock(Pool.class);
    protected final LockManager.Client locksClient = (LockManager.Client)Mockito.mock(LockManager.Client.class);
    protected final TransactionValidator transactionValidator = (TransactionValidator)Mockito.mock(TransactionValidator.class);
    protected CollectionsFactory collectionsFactory;
    protected AssertionRunnerTxExecutionMonitor transactionExecutionMonitor = new AssertionRunnerTxExecutionMonitor();
    protected PrivilegeDatabaseReferenceImpl sessionDatabase = new PrivilegeDatabaseReferenceImpl("neo4j");
    private final ProcedureView procedureView = (ProcedureView)Mockito.mock(ProcedureView.class);
    protected final Config config = Config.defaults();
    private final TransactionTimeout defaultTransactionTimeoutMillis = new TransactionTimeout((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout), (Status)Status.Transaction.TransactionTimedOut);

    KernelTransactionTestBase() {
    }

    @BeforeEach
    public void before() throws Exception {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)new TestCollectionsFactory());
        Mockito.when((Object)this.storageEngine.newReader()).thenReturn((Object)this.storageReader);
        Mockito.when((Object)this.storageEngine.newCommandCreationContext(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.commandCreationContext);
        Mockito.when((Object)this.storageEngine.metadataProvider()).thenReturn((Object)this.metadataProvider);
        Mockito.when((Object)this.storageEngine.createStorageCursors((CursorContext)ArgumentMatchers.any())).thenReturn((Object)StoreCursors.NULL);
        Mockito.when((Object)this.storageEngine.createCommands((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageReader)ArgumentMatchers.any(StorageReader.class), (CommandCreationContext)ArgumentMatchers.any(CommandCreationContext.class), (LockTracer)ArgumentMatchers.any(LockTracer.class), (TxStateVisitor.Decorator)ArgumentMatchers.any(TxStateVisitor.Decorator.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (StoreCursors)ArgumentMatchers.any(StoreCursors.class), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class))).thenReturn(List.of(new TestCommand()));
        Mockito.when((Object)this.enrichmentStrategy.check()).thenReturn((Object)EnrichmentMode.OFF);
        this.transactionExecutionMonitor.reset();
    }

    public KernelTransactionImplementation newTransaction(long transactionTimeoutMillis) {
        return this.newTransaction(0L, LoginContext.AUTH_DISABLED, new TransactionTimeout(Duration.ofMillis(transactionTimeoutMillis), (Status)Status.Transaction.TransactionTimedOutClientConfiguration), 1L);
    }

    public KernelTransactionImplementation newTransaction(LoginContext loginContext) {
        return this.newTransaction(0L, loginContext, this.defaultTransactionTimeoutMillis, 1L);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, LoginContext loginContext, TransactionTimeout transactionTimeout, long userTransactionId) {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction();
        this.initialize(lastTransactionIdWhenStarted, loginContext, transactionTimeout, userTransactionId, tx);
        return tx;
    }

    void initialize(long lastTransactionIdWhenStarted, LoginContext loginContext, TransactionTimeout transactionTimeout, long userTransactionId, KernelTransactionImplementation tx) {
        SecurityContext securityContext = loginContext.authorize(LoginContext.IdLookup.EMPTY, (PrivilegeDatabaseReference)this.sessionDatabase, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        tx.initialize(lastTransactionIdWhenStarted, KernelTransaction.Type.EXPLICIT, securityContext, transactionTimeout, userTransactionId, ClientConnectionInfo.EMBEDDED_CONNECTION, this.procedureView);
    }

    KernelTransactionImplementation newNotInitializedTransaction() {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, this.config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    KernelTransactionImplementation newNotInitializedTransaction(Config config) {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    KernelTransactionImplementation newNotInitializedTransaction(Config config, NamedDatabaseId databaseId) {
        return this.newNotInitializedTransaction(LeaseService.NO_LEASES, config, databaseId);
    }

    KernelTransactionImplementation newNotInitializedTransaction(LeaseService leaseService, Config config, NamedDatabaseId databaseId) {
        LockManager locks = (LockManager)Mockito.mock(LockManager.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)this.locksClient);
        Dependencies dependencies = Dependencies.dependenciesOf((Object)Mockito.mock(GraphDatabaseFacade.class));
        GlobalMemoryGroupTracker memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, ByteUnit.mebiBytes((long)4L), null);
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName(databaseId.name())).thenReturn(Optional.of(databaseId));
        ConfigBasedLookupFactory readOnlyLookup = new ConfigBasedLookupFactory(config, databaseIdRepository);
        DefaultReadOnlyDatabases readOnlyChecker = new DefaultReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{readOnlyLookup});
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        DefaultVersionStorageTracer versionStorageTracer = new DefaultVersionStorageTracer((PageCacheTracer)pageCacheTracer);
        TransactionValidatorFactory validatorFactory = (TransactionValidatorFactory)Mockito.mock(TransactionValidatorFactory.class);
        Mockito.when((Object)validatorFactory.createTransactionValidator((MemoryTracker)ArgumentMatchers.any(), (TransactionMonitor)ArgumentMatchers.any())).thenReturn((Object)this.transactionValidator);
        return new KernelTransactionImplementation(config, (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), null, (TransactionCommitProcess)this.commitProcess, TransactionRollbackProcess.EMPTY_ROLLBACK_PROCESS, this.transactionMonitor, this.txPool, (SystemNanoClock)this.clock, new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new DatabaseTracers((DatabaseTracer)new DefaultDatabaseTracer((PageCacheTracer)pageCacheTracer), LockTracer.NONE, (PageCacheTracer)pageCacheTracer, (VersionStorageTracer)versionStorageTracer), this.storageEngine, any -> CanWrite.INSTANCE, new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER), () -> this.collectionsFactory, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), KernelTransactionTestBase.mockedTokenHolders(), (ElementIdMapper)Mockito.mock(ElementIdMapper.class), (IndexingService)Mockito.mock(IndexingService.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, databaseId, leaseService, (ScopedMemoryPool)memoryPool, readOnlyChecker.forDatabase(databaseId), (TransactionExecutionMonitor)this.transactionExecutionMonitor, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG, locks, (TransactionCommitmentFactory)Mockito.mock(TransactionCommitmentFactory.class), (KernelTransactions)Mockito.mock(KernelTransactions.class), TransactionIdGenerator.EMPTY, (DbmsRuntimeVersionProvider)Mockito.mock(DbmsRuntimeVersionProvider.class), LatestVersions.LATEST_KERNEL_VERSION_PROVIDER, this.serverIdentity, this.enrichmentStrategy, (TransactionStateBehaviour)new KernelTransactionsStateBehaviour(this.storageEngine, this.enrichmentStrategy), (DatabaseHealth)Mockito.mock(DatabaseHealth.class), (LogProvider)NullLogProvider.getInstance(), validatorFactory, DatabaseSerialGuard.EMPTY_GUARD, this.storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED), TopologyGraphDbmsModel.HostedOnMode.SINGLE);
    }

    KernelTransactionImplementation newNotInitializedTransaction(LeaseService leaseService) {
        return this.newNotInitializedTransaction(leaseService, this.config, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    public static class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long appendIndex = 1L;
        public List<CommandBatch> transactions = new ArrayList<CommandBatch>();

        public long commit(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) {
            this.transactions.add(batch.commandBatch());
            return ++this.appendIndex;
        }
    }

    protected static final class AssertionRunnerTxExecutionMonitor
    implements TransactionExecutionMonitor {
        private Consumer<KernelTransaction> commitAssertion;
        private Consumer<KernelTransaction> rollbackAssertion;

        protected AssertionRunnerTxExecutionMonitor() {
        }

        public void setCommitAssertion(Consumer<KernelTransaction> commitAssertion) {
            this.commitAssertion = commitAssertion;
        }

        public void setRollbackAssertion(Consumer<KernelTransaction> rollbackAssertion) {
            this.rollbackAssertion = rollbackAssertion;
        }

        private void reset() {
            this.commitAssertion = null;
            this.rollbackAssertion = null;
        }

        public void start(KernelTransaction tx) {
        }

        public void commit(KernelTransaction tx) {
            if (this.commitAssertion != null) {
                this.commitAssertion.accept(tx);
            }
        }

        public void rollback(KernelTransaction tx, Throwable failure) {
            if (this.rollbackAssertion != null) {
                this.rollbackAssertion.accept(tx);
            }
        }
    }

    private static class TestCollectionsFactory
    implements CollectionsFactory {
        private TestCollectionsFactory() {
        }

        public MutableLongSet newLongSet(MemoryTracker memoryTracker) {
            return OnHeapCollectionsFactory.INSTANCE.newLongSet(memoryTracker);
        }

        public MutableLongDiffSets newLongDiffSets(MemoryTracker memoryTracker) {
            return OnHeapCollectionsFactory.INSTANCE.newLongDiffSets(memoryTracker);
        }

        public MutableLongObjectMap<Value> newObjectMap(MemoryTracker memoryTracker) {
            return new LongObjectHashMap();
        }

        public void release() {
        }
    }
}

