/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;

public class VerifyingTransactionEventListener
implements TransactionEventListener<Object> {
    private final ExpectedTransactionData expectedData;
    private boolean hasBeenCalled;
    private Throwable failure;

    public VerifyingTransactionEventListener(ExpectedTransactionData expectedData) {
        this.expectedData = expectedData;
    }

    public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
        this.verify(data);
    }

    public void afterRollback(TransactionData data, Object state, GraphDatabaseService databaseService) {
    }

    public Object beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) {
        return this.verify(data);
    }

    private Object verify(TransactionData data) {
        if (Iterables.count((Iterable)data.createdNodes()) == 0L) {
            return null;
        }
        try {
            this.expectedData.compareTo(data);
            this.hasBeenCalled = true;
            return null;
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    boolean hasBeenCalled() {
        return this.hasBeenCalled;
    }

    Throwable failure() {
        return this.failure;
    }
}

