/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.values.storable.ValueTuple;

public class IndexTxStateUpdaterTestBase {
    static final int PROP_ID_1 = 20;
    static final int PROP_ID_2 = 21;
    static final int PROP_ID_3 = 22;
    static final int NEW_PROP_ID = 23;
    static final int UN_INDEXED_PROP_ID = 24;
    static final int[] PROPS = new int[]{20, 21, 22};
    TransactionState txState;
    IndexTxStateUpdater indexTxUpdater;
    StubPropertyCursor propertyCursor = new StubPropertyCursor();
    StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);

    void setUp(List<IndexDescriptor> indexes) throws IndexNotFoundKernelException {
        this.txState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)this.txState.memoryTracker()).thenReturn((Object)EmptyMemoryTracker.INSTANCE);
        Mockito.when((Object)this.storageReader.valueIndexesGetRelated((int[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (EntityType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            int[] tokens = (int[])invocationOnMock.getArgument(0);
            int propertyKeyId = (Integer)invocationOnMock.getArgument(1);
            HashSet<IndexDescriptor> descriptors = new HashSet<IndexDescriptor>();
            for (IndexDescriptor index : indexes) {
                SchemaDescriptor schema = index.schema();
                if (!schema.isAffected(tokens) || !ArrayUtils.contains((int[])schema.getPropertyIds(), (int)propertyKeyId) || schema.propertySchemaType() != PropertySchemaType.COMPLETE_ALL_TOKENS) continue;
                descriptors.add(index);
            }
            return descriptors;
        });
        Mockito.when((Object)this.storageReader.valueIndexesGetRelated((int[])ArgumentMatchers.any(), (int[])ArgumentMatchers.any(int[].class), (EntityType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            int[] tokens = (int[])invocationOnMock.getArgument(0);
            int[] propertyKeyIds = (int[])invocationOnMock.getArgument(1);
            HashSet<IndexDescriptor> descriptors = new HashSet<IndexDescriptor>();
            for (IndexDescriptor index : indexes) {
                if (!index.schema().isAffected(tokens)) continue;
                boolean containsAll = true;
                for (int propertyId : index.schema().getPropertyIds()) {
                    containsAll &= ArrayUtils.contains((int[])propertyKeyIds, (int)propertyId);
                }
                if (!containsAll) continue;
                descriptors.add(index);
            }
            return descriptors;
        });
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).thenReturn((Object)indexProxy);
        TxStateHolder txStateHolder = (TxStateHolder)Mockito.mock(TxStateHolder.class);
        Mockito.when((Object)txStateHolder.txState()).thenReturn((Object)this.txState);
        this.indexTxUpdater = new IndexTxStateUpdater(this.storageReader, indexingService, txStateHolder);
    }

    static ValueTuple values(Object ... values) {
        return ValueTuple.of((Object[])values);
    }

    void verifyIndexUpdate(SchemaDescriptor schema, long entityId, ValueTuple before, ValueTuple after) {
        ((TransactionState)Mockito.verify((Object)this.txState)).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.eq((Object)schema), ArgumentMatchers.eq((long)entityId), (ValueTuple)ArgumentMatchers.eq((Object)before), (ValueTuple)ArgumentMatchers.eq((Object)after));
    }
}

