/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.assertj.core.api.Assertions;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class UpgradeTestUtil {
    public static void upgradeDatabase(DatabaseManagementService dbms, GraphDatabaseAPI db, KernelVersion expectedCurrentVersion, KernelVersion expectedUpgradedVersions) {
        UpgradeTestUtil.assertKernelVersion(db, expectedCurrentVersion);
        UpgradeTestUtil.upgradeDbms(dbms);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)db);
        UpgradeTestUtil.assertKernelVersion(db, expectedUpgradedVersions);
    }

    public static void createWriteTransaction(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    private static KernelVersion getKernelVersion(GraphDatabaseAPI db) {
        return ((KernelVersionProvider)db.getDependencyResolver().resolveDependency(KernelVersionProvider.class)).kernelVersion();
    }

    public static void assertKernelVersion(GraphDatabaseAPI database, KernelVersion expectedVersion) {
        Assertions.assertThat((Comparable)UpgradeTestUtil.getKernelVersion(database)).isEqualTo((Object)expectedVersion);
    }

    public static void upgradeDbms(DatabaseManagementService dbms) {
        GraphDatabaseAPI system = (GraphDatabaseAPI)dbms.database("system");
        try (Transaction tx = system.beginTx();){
            tx.execute("CALL dbms.upgrade()").close();
            tx.commit();
        }
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, GraphDatabaseAPI db) throws Exception {
        LogicalTransactionStore lts = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        UpgradeTestUtil.assertUpgradeTransactionInOrder(from, to, fromTxId, (ThrowingSupplier<CommandBatchCursor, IOException>)((ThrowingSupplier)() -> lts.getCommandBatches(fromTxId + 1L)));
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, ThrowingSupplier<CommandBatchCursor, IOException> commandBatchCursorSupplier) throws Exception {
        ArrayList<KernelVersion> transactionVersions = new ArrayList<KernelVersion>();
        ArrayList<CommittedTransactionRepresentation> transactions = new ArrayList<CommittedTransactionRepresentation>();
        try (CommandBatchCursor commandBatchCursor = (CommandBatchCursor)commandBatchCursorSupplier.get();){
            while (commandBatchCursor.next()) {
                CommittedTransactionRepresentation representation = (CommittedTransactionRepresentation)commandBatchCursor.get();
                if (representation.txId() <= fromTxId) continue;
                transactions.add(representation);
                transactionVersions.add(representation.startEntry().kernelVersion());
            }
        }
        Assertions.assertThat(transactionVersions).hasSizeGreaterThanOrEqualTo(2);
        Assertions.assertThat(transactionVersions).isSortedAccordingTo(Comparator.comparingInt(KernelVersion::version));
        Assertions.assertThat((Comparable)((KernelVersion)transactionVersions.get(0))).isEqualTo((Object)from);
        Assertions.assertThat((Comparable)((KernelVersion)transactionVersions.get(transactionVersions.size() - 1))).isEqualTo((Object)to);
        int indexFirstOnNew = transactionVersions.indexOf(to);
        CommittedCommandBatch upgradeTransaction = (CommittedCommandBatch)transactions.get(indexFirstOnNew - 1);
        CommandBatch commands = upgradeTransaction.commandBatch();
        for (StorageCommand command : commands) {
            Assertions.assertThat((Object)command).isInstanceOf(StorageCommand.VersionUpgradeCommand.class);
        }
    }
}

