/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.procedure.impl.CustomExtensionFactory;
import org.neo4j.procedure.impl.CustomProcedures;
import org.neo4j.test.jar.JarBuilder;

public final class CustomExtensionUtils {
    private CustomExtensionUtils() {
    }

    public static String LOG_MARKER() {
        return "Oh my...";
    }

    public static void createProcedureJar(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (JarOutputStream jarOut = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            CustomExtensionUtils.writeClass(jarOut, CustomExtensionUtils.redefineToPublic(CustomProcedures.class));
        }
    }

    public static void createExtensionJar(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (JarOutputStream jarOut = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            DynamicType.Unloaded<CustomExtensionFactory> redefinedExtension = CustomExtensionUtils.redefineToPublic(CustomExtensionFactory.class);
            CustomExtensionUtils.writeClass(jarOut, redefinedExtension);
            CustomExtensionUtils.writeClass(jarOut, CustomExtensionUtils.redefineToPublic(CustomProcedures.class));
            CustomExtensionUtils.addService(jarOut, ExtensionFactory.class.getCanonicalName(), redefinedExtension.getTypeDescription().getCanonicalName());
        }
    }

    private static <T> DynamicType.Unloaded<T> redefineToPublic(Class<T> cls) {
        return new ByteBuddy().redefine(cls).name(cls.getName() + "Public").modifiers(1).make();
    }

    private static void writeClass(JarOutputStream stream, DynamicType.Unloaded<?> redefined) throws IOException {
        stream.putNextEntry(new ZipEntry(CustomExtensionUtils.toFilename(redefined.getTypeDescription().getCanonicalName())));
        stream.write(redefined.getBytes());
        stream.closeEntry();
    }

    private static void writeClass(JarOutputStream stream, Class<?> cls) throws IOException {
        String filename = CustomExtensionUtils.toFilename(cls.getCanonicalName());
        stream.putNextEntry(new ZipEntry(filename));
        stream.write(JarBuilder.classCompiledBytes((String)filename));
        stream.closeEntry();
    }

    private static String toFilename(String canonicalName) {
        return canonicalName.replace('.', '/') + ".class";
    }

    private static void addService(JarOutputStream stream, String iface, String cls) throws IOException {
        stream.putNextEntry(new ZipEntry("META-INF/services/" + iface));
        stream.write(cls.getBytes(StandardCharsets.UTF_8));
    }
}

