/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;

public class TestTokenScanConsumer
implements TokenScanConsumer {
    private static final Monitor NO_MONITOR = (entityId, tokens) -> {};
    public final List<List<Record>> batches = Collections.synchronizedList(new ArrayList());
    private final Set<Long> entities = new HashSet<Long>();
    private final Monitor monitor;

    public TestTokenScanConsumer() {
        this(NO_MONITOR);
    }

    public TestTokenScanConsumer(Monitor monitor) {
        this.monitor = monitor;
    }

    public long consumedEntities() {
        return this.entities.size();
    }

    public TokenScanConsumer.Batch newBatch() {
        return new TokenScanConsumer.Batch(){
            final List<Record> batchTokenUpdates = new ArrayList<Record>();

            public void addRecord(long entityId, long[] tokens) {
                this.batchTokenUpdates.add(new Record(entityId, tokens));
                TestTokenScanConsumer.this.entities.add(entityId);
                TestTokenScanConsumer.this.monitor.recordAdded(entityId, tokens);
            }

            public void process() {
                TestTokenScanConsumer.this.batches.add(this.batchTokenUpdates);
            }
        };
    }

    public static interface Monitor {
        public void recordAdded(long var1, long[] var3);
    }

    public static class Record {
        private final long entityId;
        private final long[] tokens;

        public Record(long entityId, long[] tokens) {
            this.entityId = entityId;
            this.tokens = tokens;
        }

        public long getEntityId() {
            return this.entityId;
        }

        public long[] getTokens() {
            return this.tokens;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.entityId == record.entityId && Arrays.equals(this.tokens, record.tokens);
        }

        public int hashCode() {
            int result = Objects.hash(this.entityId);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }
    }
}

