/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.vector;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class VectorTestUtils {
    public static final Iterable<Value> EUCLIDEAN_VALID_VECTORS_FROM_VALUE;
    public static final Iterable<Value> EUCLIDEAN_INVALID_VECTORS_FROM_VALUE;
    public static final Iterable<List<Double>> EUCLIDEAN_VALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<List<Double>> EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<Value> COSINE_VALID_VECTORS_FROM_VALUE;
    public static final Iterable<Value> COSINE_INVALID_VECTORS_FROM_VALUE;
    public static final Iterable<List<Double>> COSINE_VALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<List<Double>> COSINE_INVALID_VECTORS_FROM_DOUBLE_LIST;

    private static float[] toPrimitive(float ... array) {
        return array;
    }

    private static double[] toPrimitive(double ... array) {
        return array;
    }

    private static double[] promote(float ... array) {
        double[] promoted = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            promoted[i] = array[i];
        }
        return promoted;
    }

    private static double extremeSameFloatValue(double value) {
        int floatSignificandWidth = 24;
        int doubleSignificandWidth = 53;
        int mask = 0xFFFFFFF;
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) | 0xFFFFFFFL);
    }

    static {
        double smallerDoubleThanSmallestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(-3.4028234663852886E38);
        double smallerDoubleThanSmallestFloat = Math.nextDown(smallerDoubleThanSmallestFloatButSameValue);
        double largerDoubleThanLargestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(3.4028234663852886E38);
        double largerDoubleThanLargestFloat = Math.nextUp(largerDoubleThanLargestFloatButSameValue);
        float smallestPositiveFloat = Math.nextUp(0.0f);
        float squareRootLargestFloat = (float)Math.sqrt(3.4028234663852886E38);
        double largerThanSquareRootLargestDouble = Math.nextUp(Math.sqrt(Double.MAX_VALUE));
        ImmutableFloatList finitePrimitiveNonZeroFloats = FloatLists.immutable.of(new float[]{-3.4028235E38f, -1.1754944E-38f, -1.4E-45f, Float.MIN_VALUE, Float.MIN_NORMAL, Float.MAX_VALUE});
        ImmutableList finitePrimitiveNonZeroFloatArrays = Lists.mutable.withAll((Iterable)finitePrimitiveNonZeroFloats.asLazy().collect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0))).toImmutableList();
        ImmutableList finiteBoxedNonZeroFloatArrays = finitePrimitiveNonZeroFloatArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteNonZeroFloatArrays = Lists.mutable.withAll((Iterable)finitePrimitiveNonZeroFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteBoxedNonZeroFloatArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableList finitePrimitiveNonZeroDoubleArrays = DoubleLists.mutable.of(new double[]{smallerDoubleThanSmallestFloatButSameValue, largerDoubleThanLargestFloatButSameValue}).withAll((DoubleIterable)finitePrimitiveNonZeroFloats.asLazy().collectDouble((FloatToDoubleFunction & Serializable)v -> v)).collect((DoubleToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).toImmutableList();
        ImmutableList finiteBoxedNonZeroDoubleArrays = finitePrimitiveNonZeroDoubleArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteNonZeroDoubleArrays = Lists.mutable.withAll((Iterable)finitePrimitiveNonZeroDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteBoxedNonZeroDoubleArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableFloatList finitePrimitiveZeroFloats = FloatLists.immutable.of(new float[]{-0.0f, 0.0f});
        ImmutableList finitePrimitiveZeroFloatArrays = Lists.mutable.withAll((Iterable)finitePrimitiveZeroFloats.asLazy().collect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0))).toImmutableList();
        ImmutableList finiteBoxedZeroFloatArrays = finitePrimitiveZeroFloatArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteZeroFloatArrays = Lists.mutable.withAll((Iterable)finitePrimitiveZeroFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteBoxedZeroFloatArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableList finitePrimitiveZeroDoubleArrays = finitePrimitiveZeroFloatArrays.collect(VectorTestUtils::promote);
        ImmutableList finiteBoxedZeroDoubleArrays = finitePrimitiveZeroDoubleArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteZeroDoubleArrays = Lists.mutable.withAll((Iterable)finitePrimitiveZeroDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteBoxedZeroDoubleArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableList finiteL2NormPrimitiveFloatArrays = Lists.immutable.of((Object)VectorTestUtils.toPrimitive(smallestPositiveFloat, smallestPositiveFloat), (Object)VectorTestUtils.toPrimitive(squareRootLargestFloat, squareRootLargestFloat));
        ImmutableList finiteL2NormBoxedFloatArrays = finiteL2NormPrimitiveFloatArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteL2NormFloatArrays = Lists.mutable.withAll((Iterable)finiteL2NormPrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteL2NormBoxedFloatArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableList finiteL2NormPrimitiveDoubleArrays = finiteL2NormPrimitiveFloatArrays.collect(VectorTestUtils::promote);
        ImmutableList finiteL2NormBoxedDoubleArrays = finiteL2NormPrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        ImmutableList finiteL2NormDoubleArrays = Lists.mutable.withAll((Iterable)finiteL2NormPrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)finiteL2NormBoxedDoubleArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableFloatList nonFinitePrimitiveFloats = FloatLists.immutable.of(new float[]{Float.NaN, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY});
        ImmutableList nonFinitePrimitiveFloatArrays = FloatLists.mutable.withAll((FloatIterable)nonFinitePrimitiveFloats).collect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).with((Object)new float[0]).with(null).toImmutableList();
        ImmutableList nonFiniteBoxedFloatArrays = nonFinitePrimitiveFloatArrays.collect(ArrayUtils::toObject);
        ImmutableList nonFiniteFloatArrays = Lists.mutable.withAll((Iterable)nonFinitePrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFiniteBoxedFloatArrays.asLazy().collect(Values::of)).with((Object)Values.NO_VALUE).with(null).toImmutableList();
        ImmutableList nonFinitePrimitiveDoubleArrays = DoubleLists.mutable.of(new double[]{smallerDoubleThanSmallestFloat, largerDoubleThanLargestFloat}).withAll((DoubleIterable)nonFinitePrimitiveFloats.asLazy().collectDouble((FloatToDoubleFunction & Serializable)v -> v)).collect((DoubleToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0)).with(null).toImmutableList();
        ImmutableList nonFiniteBoxedDoubleArrays = nonFinitePrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        ImmutableList nonFiniteDoubleArrays = Lists.mutable.withAll((Iterable)nonFinitePrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFiniteBoxedDoubleArrays.asLazy().collect(Values::of)).with((Object)Values.NO_VALUE).with(null).toImmutableList();
        ImmutableList nonFiniteL2NormPrimitiveFloatArrays = Lists.immutable.of((Object)VectorTestUtils.toPrimitive(0.0f, 0.0f), (Object)VectorTestUtils.toPrimitive(0.0f, 0.0f), (Object)VectorTestUtils.toPrimitive(0.0f, 0.0f), (Object)VectorTestUtils.toPrimitive(0.0f, 0.0f));
        ImmutableList nonFiniteL2NormBoxedFloatArrays = nonFiniteL2NormPrimitiveFloatArrays.collect(ArrayUtils::toObject);
        ImmutableList nonFiniteL2NormFloatArrays = Lists.mutable.withAll((Iterable)nonFiniteL2NormPrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFiniteL2NormBoxedFloatArrays.asLazy().collect(Values::of)).toImmutableList();
        ImmutableList nonFiniteL2NormPrimitiveDoubleArrays = Lists.mutable.of((Object[])new double[][]{VectorTestUtils.toPrimitive(largerThanSquareRootLargestDouble, largerThanSquareRootLargestDouble)}).withAll((Iterable)nonFiniteL2NormPrimitiveFloatArrays.asLazy().collect(VectorTestUtils::promote)).toImmutableList();
        ImmutableList nonFiniteL2NormBoxedDoubleArrays = nonFiniteL2NormPrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        ImmutableList nonFiniteL2NormDoubleArrays = Lists.mutable.withAll((Iterable)nonFiniteL2NormPrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFiniteL2NormBoxedDoubleArrays.asLazy().collect(Values::of)).toImmutableList();
        COSINE_VALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)finiteNonZeroFloatArrays).withAll((Iterable)finiteNonZeroDoubleArrays).withAll((Iterable)finiteL2NormFloatArrays).withAll((Iterable)finiteL2NormDoubleArrays).toImmutableList();
        COSINE_VALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)finiteBoxedNonZeroDoubleArrays).withAll((Iterable)finiteL2NormBoxedDoubleArrays).asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList).toImmutableList();
        EUCLIDEAN_VALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)finiteZeroFloatArrays).withAll((Iterable)finiteZeroDoubleArrays).withAll(COSINE_VALID_VECTORS_FROM_VALUE).toImmutableList();
        EUCLIDEAN_VALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)finiteBoxedZeroDoubleArrays).collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList).withAll(COSINE_VALID_VECTORS_FROM_DOUBLE_LIST).toImmutableList();
        EUCLIDEAN_INVALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)nonFiniteFloatArrays).withAll((Iterable)nonFiniteDoubleArrays).with(null).toImmutableList();
        EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)nonFiniteBoxedDoubleArrays.asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList)).with(null).toImmutableList();
        COSINE_INVALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)nonFiniteL2NormFloatArrays).withAll((Iterable)nonFiniteL2NormDoubleArrays).withAll(EUCLIDEAN_INVALID_VECTORS_FROM_VALUE).toImmutableList();
        COSINE_INVALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)nonFiniteL2NormBoxedDoubleArrays.asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList)).withAll(EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST).toImmutableList();
    }
}

