/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.assertj.core.api.Assertions;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class UpgradeTestUtil {
    public static void upgradeDatabase(DatabaseManagementService dbms, GraphDatabaseAPI db, KernelVersion expectedCurrentVersion, KernelVersion expectedUpgradedVersions) {
        UpgradeTestUtil.assertKernelVersion(db, expectedCurrentVersion);
        UpgradeTestUtil.upgradeDbms(dbms);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)db);
        UpgradeTestUtil.assertKernelVersion(db, expectedUpgradedVersions);
    }

    public static void createWriteTransaction(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    private static KernelVersion getKernelVersion(GraphDatabaseAPI db) {
        return ((KernelVersionProvider)db.getDependencyResolver().resolveDependency(KernelVersionProvider.class)).kernelVersion();
    }

    public static void assertKernelVersion(GraphDatabaseAPI database, KernelVersion expectedVersion) {
        Assertions.assertThat((Comparable)UpgradeTestUtil.getKernelVersion(database)).isEqualTo((Object)expectedVersion);
    }

    public static void upgradeDbms(DatabaseManagementService dbms) {
        GraphDatabaseAPI system = (GraphDatabaseAPI)dbms.database("system");
        try (Transaction tx = system.beginTx();){
            tx.execute("CALL dbms.upgrade()").close();
            tx.commit();
        }
    }
}

