/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadUtils;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;

public final class LogChannelUtils {
    private LogChannelUtils() {
    }

    public static FlushableLogPositionAwareChannel getWriteChannel(FileSystemAbstraction fs, Path path, KernelVersion kernelVersion) throws IOException {
        StoreChannel storeChannel = fs.open(path, Set.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE));
        LogHeader logHeader = LogChannelUtils.getLogHeader(kernelVersion);
        LogFormat.writeLogHeader((StoreChannel)storeChannel, (LogHeader)logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        PhysicalLogVersionedStoreChannel logChannel = new PhysicalLogVersionedStoreChannel(storeChannel, logHeader, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL);
        return new PhysicalFlushableLogPositionAwareChannel((LogVersionedStoreChannel)logChannel, logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public static ReadableLogPositionAwareChannel getReadChannel(FileSystemAbstraction fs, Path path, KernelVersion kernelVersion) throws IOException {
        StoreChannel storeChannel = fs.open(path, Set.of(StandardOpenOption.READ));
        LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)storeChannel, (boolean)true, (Path)path, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        LogChannelUtils.validateKernelVersion(kernelVersion, logHeader);
        PhysicalLogVersionedStoreChannel logChannel = new PhysicalLogVersionedStoreChannel(storeChannel, logHeader, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL);
        return ReadAheadUtils.newChannel((LogVersionedStoreChannel)logChannel, (LogHeader)logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public static int estimateBytesWrittenToLogChannel(int dataSize, LogHeader logHeader, boolean withChecksumAndVersion) {
        return LogChannelUtils.estimateBytesWrittenToLogChannel(dataSize, withChecksumAndVersion, logHeader);
    }

    public static int estimateBytesWrittenToLogChannel(int dataSize, boolean withChecksumAndVersion, LogHeader logHeader) {
        if (logHeader.getLogFormatVersion().usesSegments()) {
            int estimatedSegmentsRequired = (dataSize - 1) / (logHeader.getSegmentBlockSize() - 31) + 1;
            return estimatedSegmentsRequired * 31 + dataSize;
        }
        if (withChecksumAndVersion) {
            return 1 + dataSize + 4;
        }
        return dataSize;
    }

    private static void validateKernelVersion(KernelVersion kernelVersion, LogHeader logHeader) {
        if (logHeader.getLogFormatVersion().getVersionByte() != LogFormat.fromKernelVersion((KernelVersion)kernelVersion).getVersionByte()) {
            throw new AssertionError((Object)("Expected log format version " + String.valueOf(logHeader.getLogFormatVersion()) + " but got " + LogFormat.fromKernelVersion((KernelVersion)kernelVersion).getVersionByte()));
        }
    }

    private static LogHeader getLogHeader(KernelVersion kernelVersion) {
        LogFormat logFormat = LogFormat.fromKernelVersion((KernelVersion)kernelVersion);
        return logFormat.newHeader(0L, 1L, -1L, StoreId.UNKNOWN, logFormat.getDefaultSegmentBlockSize(), -559063315, kernelVersion);
    }
}

