/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.assertj.core.api.Assertions;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.io.memory.ByteBufferFactory;

public final class SchemaTestUtil {
    public static final TokenNameLookup SIMPLE_NAME_LOOKUP = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return "Label" + labelId;
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return "RelType" + relationshipTypeId;
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return "property" + propertyKeyId;
        }
    };

    private SchemaTestUtil() {
    }

    public static void assertEquality(Object o1, Object o2) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)o1, (Object)o2, (String)(o1.getClass().getSimpleName() + "s are not equal"));
        org.junit.jupiter.api.Assertions.assertEquals((int)o1.hashCode(), (int)o2.hashCode(), (String)(o1.getClass().getSimpleName() + "s do not have the same hashcode"));
    }

    static void assertArray(int[] values, int ... expected) {
        Assertions.assertThat((int)values.length).isEqualTo(expected.length);
        for (int i = 0; i < values.length; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)values[i], (int)expected[i], (String)String.format("Expected %d, got %d at index %d", expected[i], values[i], i));
        }
    }

    public static ByteBufferFactory defaultHeapBufferFactory() {
        return ByteBufferFactory.heapBufferFactory((int)((Long)Config.defaults().get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
    }
}

