/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.CompleteBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class UpgradeTestUtil {
    private static final Consumer<Iterable<? extends StorageCommand>> ASSERT_DEFAULT_UPGRADE_TRANSACTION = c -> ((ObjectAssert)((IterableAssert)Assertions.assertThat((Iterable)c).hasSize(1)).first()).isInstanceOf(StorageCommand.VersionUpgradeCommand.class);

    public static void upgradeDatabase(DatabaseManagementService dbms, GraphDatabaseAPI db, KernelVersion expectedCurrentVersion, KernelVersion expectedUpgradedVersions) {
        UpgradeTestUtil.assertKernelVersion(db, expectedCurrentVersion);
        UpgradeTestUtil.upgradeDbms(dbms);
        UpgradeTestUtil.createWriteTransaction((GraphDatabaseService)db);
        UpgradeTestUtil.assertKernelVersion(db, expectedUpgradedVersions);
    }

    public static void createWriteTransaction(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    private static KernelVersion getKernelVersion(GraphDatabaseAPI db) {
        return ((KernelVersionProvider)db.getDependencyResolver().resolveDependency(KernelVersionProvider.class)).kernelVersion();
    }

    public static void assertKernelVersion(GraphDatabaseAPI database, KernelVersion expectedVersion) {
        Assertions.assertThat((Comparable)UpgradeTestUtil.getKernelVersion(database)).isEqualTo((Object)expectedVersion);
    }

    public static void upgradeDbms(DatabaseManagementService dbms) {
        GraphDatabaseService system = dbms.database("system");
        try {
            UpgradeTestUtil.manuallyUpgrade(system);
        }
        catch (Exception e) {
            throw new RuntimeException("this was unexpected...", e);
        }
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, GraphDatabaseAPI db) throws Exception {
        UpgradeTestUtil.assertUpgradeTransactionInOrder(from, to, fromTxId, db, ASSERT_DEFAULT_UPGRADE_TRANSACTION);
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, GraphDatabaseAPI db, Consumer<Iterable<? extends StorageCommand>> upgradeTransactionRequirement) throws Exception {
        LogicalTransactionStore lts = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        UpgradeTestUtil.assertUpgradeTransactionInOrder(from, to, fromTxId, (ThrowingSupplier<CommandBatchCursor, IOException>)((ThrowingSupplier)() -> lts.getCommandBatches(fromTxId + 1L)), upgradeTransactionRequirement);
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, ThrowingSupplier<CommandBatchCursor, IOException> commandBatchCursorSupplier) throws Exception {
        UpgradeTestUtil.assertUpgradeTransactionInOrder(from, to, fromTxId, commandBatchCursorSupplier, ASSERT_DEFAULT_UPGRADE_TRANSACTION);
    }

    public static void assertUpgradeTransactionInOrder(KernelVersion from, KernelVersion to, long fromTxId, ThrowingSupplier<CommandBatchCursor, IOException> commandBatchCursorSupplier, Consumer<Iterable<? extends StorageCommand>> upgradeTransactionRequirement) throws Exception {
        ArrayList<KernelVersion> transactionVersions = new ArrayList<KernelVersion>();
        ArrayList<CompleteBatchRepresentation> transactions = new ArrayList<CompleteBatchRepresentation>();
        try (CommandBatchCursor commandBatchCursor = (CommandBatchCursor)commandBatchCursorSupplier.get();){
            while (commandBatchCursor.next()) {
                CompleteBatchRepresentation representation = (CompleteBatchRepresentation)commandBatchCursor.get();
                if (representation.txId() <= fromTxId) continue;
                transactions.add(representation);
                transactionVersions.add(representation.startEntry().kernelVersion());
            }
        }
        Assertions.assertThat(transactionVersions).hasSizeGreaterThanOrEqualTo(2);
        Assertions.assertThat(transactionVersions).isSortedAccordingTo(Comparator.comparingInt(KernelVersion::version));
        Assertions.assertThat((Comparable)((KernelVersion)transactionVersions.getFirst())).isEqualTo((Object)from);
        Assertions.assertThat((Comparable)((KernelVersion)transactionVersions.getLast())).isEqualTo((Object)to);
        int indexFirstOnNew = transactionVersions.indexOf(to);
        CommittedCommandBatchRepresentation upgradeTransaction = (CommittedCommandBatchRepresentation)transactions.get(indexFirstOnNew - 1);
        CommandBatch commands = upgradeTransaction.commandBatch();
        Assertions.assertThat((Iterable)commands).satisfies(new Consumer[]{upgradeTransactionRequirement});
    }

    public static void manuallyUpgrade(GraphDatabaseService systemDb) throws Exception {
        ((SystemGraphComponents)((GraphDatabaseAPI)systemDb).getDependencyResolver().resolveDependency(SystemGraphComponents.class)).upgradeToCurrent(systemDb);
    }
}

