/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.info.JvmMetadataRepository;

public class CannedJvmMetadataRepository
extends JvmMetadataRepository {
    private final String javaVmName;
    private final String javaVersion;
    private final List<String> inputArguments;
    private final long initialHeapSize;
    private final long maxHeapSize;

    CannedJvmMetadataRepository(String javaVmName, String javaVersion) {
        this(javaVmName, javaVersion, Collections.emptyList(), 1L, 2L);
    }

    CannedJvmMetadataRepository(String javaVmName, String javaVersion, List<String> inputArguments, long initialHeapSize, long maxHeapSize) {
        this.javaVmName = javaVmName;
        this.javaVersion = javaVersion;
        this.inputArguments = inputArguments;
        this.initialHeapSize = initialHeapSize;
        this.maxHeapSize = maxHeapSize;
    }

    public String getJavaVmName() {
        return this.javaVmName;
    }

    public Runtime.Version getJavaVersion() {
        return Runtime.Version.parse(this.javaVersion);
    }

    public List<String> getJvmInputArguments() {
        return this.inputArguments;
    }

    public MemoryUsage getHeapMemoryUsage() {
        return new MemoryUsage(this.initialHeapSize, 0L, 0L, this.maxHeapSize);
    }
}

