/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;

public class GraphDescription
implements GraphDefinition {
    private static final PROP[] NO_PROPS = new PROP[0];
    private static final NODE[] NO_NODES = new NODE[0];
    private static final REL[] NO_RELS = new REL[0];
    private static final GraphDescription EMPTY = new GraphDescription(NO_NODES, NO_RELS){

        @Override
        public Map<String, Node> create(GraphDatabaseService graphdb) {
            return new HashMap<String, Node>();
        }
    };
    private final NODE[] nodes;
    private final REL[] rels;

    public static TestData.Producer<Map<String, Node>> createGraphFor(final GraphHolder holder) {
        return new TestData.Producer<Map<String, Node>>(){

            @Override
            public Map<String, Node> create(GraphDefinition graph, String title, String documentation) {
                return graph.create(holder.graphdb());
            }
        };
    }

    @Override
    public Map<String, Node> create(GraphDatabaseService graphdb) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        try (Transaction tx = graphdb.beginTx();){
            for (NODE nODE : this.nodes) {
                Node node = GraphDescription.init(tx.createNode(), nODE.setNameProperty() ? nODE.name() : null, nODE.properties());
                for (LABEL label : nODE.labels()) {
                    node.addLabel(Label.label((String)label.value()));
                }
                result.put(nODE.name(), node);
            }
            for (Annotation annotation : this.rels) {
                GraphDescription.init(((Node)result.get(annotation.start())).createRelationshipTo((Node)result.get(annotation.end()), RelationshipType.withName((String)annotation.type())), annotation.setNameProperty() ? annotation.name() : null, annotation.properties());
            }
            tx.commit();
        }
        return result;
    }

    private static <T extends Entity> T init(T entity, String name, PROP[] properties) {
        block3: for (PROP prop : properties) {
            PropType tpe = prop.type();
            switch (tpe.ordinal()) {
                case 0: {
                    entity.setProperty(prop.key(), tpe.convert(prop.componentType(), prop.value()));
                    continue block3;
                }
                default: {
                    entity.setProperty(prop.key(), prop.type().convert(prop.value()));
                }
            }
        }
        if (name != null) {
            entity.setProperty("name", (Object)name);
        }
        return entity;
    }

    public static GraphDescription create(String ... definition) {
        HashMap<String, NODE> nodes = new HashMap<String, NODE>();
        ArrayList<REL> relationships = new ArrayList<REL>();
        GraphDescription.parse(definition, nodes, relationships);
        return new GraphDescription(nodes.values().toArray(NO_NODES), relationships.toArray(NO_RELS));
    }

    public static GraphDescription create(Graph graph) {
        if (graph == null) {
            return EMPTY;
        }
        HashMap<String, NODE> nodes = new HashMap<String, NODE>();
        for (NODE node : graph.nodes()) {
            if (nodes.put(GraphDescription.defined(node.name()), node) == null) continue;
            throw new IllegalArgumentException("Node \"" + node.name() + "\" defined more than once");
        }
        HashMap<String, REL> rels = new HashMap<String, REL>();
        ArrayList<REL> relationships = new ArrayList<REL>();
        for (REL rel : graph.relationships()) {
            GraphDescription.createIfAbsent(nodes, rel.start(), new String[0]);
            GraphDescription.createIfAbsent(nodes, rel.end(), new String[0]);
            String name = rel.name();
            if (!name.equals("") && rels.put(name, rel) != null) {
                throw new IllegalArgumentException("Relationship \"" + name + "\" defined more than once");
            }
            relationships.add(rel);
        }
        GraphDescription.parse(graph.value(), nodes, relationships);
        return new GraphDescription(nodes.values().toArray(NO_NODES), relationships.toArray(NO_RELS));
    }

    private static void createIfAbsent(Map<String, NODE> nodes, String name, String ... labels) {
        if (!nodes.containsKey(name)) {
            nodes.put(name, new DefaultNode(name, labels));
        } else {
            NODE preexistingNode = nodes.get(name);
            HashSet<String> joinedLabels = new HashSet<String>(Arrays.asList(labels));
            for (LABEL label : preexistingNode.labels()) {
                joinedLabels.add(label.value());
            }
            String[] labelNameArray = joinedLabels.toArray(new String[0]);
            nodes.put(name, new NodeWithAddedLabels(preexistingNode, labelNameArray));
        }
    }

    private static String parseAndCreateNodeIfAbsent(Map<String, NODE> nodes, String descriptionToParse) {
        String[] parts = descriptionToParse.split(":");
        if (parts.length == 0) {
            throw new IllegalArgumentException("Empty node names are not allowed.");
        }
        GraphDescription.createIfAbsent(nodes, parts[0], Arrays.copyOfRange(parts, 1, parts.length));
        return parts[0];
    }

    private static void parse(String[] description, Map<String, NODE> nodes, List<REL> relationships) {
        for (String part : description) {
            for (String line : part.split("\n")) {
                String[] components = line.split(" ");
                if (components.length != 3) {
                    throw new IllegalArgumentException("syntax error: \"" + line + "\"");
                }
                String startName = GraphDescription.parseAndCreateNodeIfAbsent(nodes, GraphDescription.defined(components[0]));
                String endName = GraphDescription.parseAndCreateNodeIfAbsent(nodes, GraphDescription.defined(components[2]));
                relationships.add(new DefaultRel(startName, components[1], endName));
            }
        }
    }

    private GraphDescription(NODE[] nodes, REL[] rels) {
        this.nodes = nodes;
        this.rels = rels;
    }

    static String defined(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Node name not provided");
        }
        return name;
    }

    @Target(value={})
    public static @interface NODE {
        public String name();

        public PROP[] properties() default {};

        public LABEL[] labels() default {};

        public boolean setNameProperty() default false;
    }

    @Target(value={})
    public static @interface PROP {
        public String key();

        public String value();

        public PropType type() default PropType.STRING;

        public PropType componentType() default PropType.ERROR;
    }

    @Target(value={})
    public static @interface LABEL {
        public String value();
    }

    @Target(value={})
    public static @interface REL {
        public String name() default "";

        public String type();

        public String start();

        public String end();

        public PROP[] properties() default {};

        public boolean setNameProperty() default false;
    }

    public static enum PropType {
        ARRAY{

            @Override
            Object convert(PropType componentType, String value) {
                String[] items = value.split(" *, *");
                Object[] result = (Object[])Array.newInstance(componentType.componentClass(), items.length);
                for (int i = 0; i < items.length; ++i) {
                    result[i] = componentType.convert(items[i]);
                }
                return result;
            }
        }
        ,
        STRING{

            @Override
            String convert(String value) {
                return value;
            }

            @Override
            Class<?> componentClass() {
                return String.class;
            }
        }
        ,
        INTEGER{

            @Override
            Long convert(String value) {
                return Long.parseLong(value);
            }

            @Override
            Class<?> componentClass() {
                return Long.class;
            }
        }
        ,
        DOUBLE{

            @Override
            Double convert(String value) {
                return Double.parseDouble(value);
            }

            @Override
            Class<?> componentClass() {
                return Double.class;
            }
        }
        ,
        BOOLEAN{

            @Override
            Boolean convert(String value) {
                return Boolean.parseBoolean(value);
            }

            @Override
            Class<?> componentClass() {
                return Boolean.class;
            }
        }
        ,
        ERROR{};


        Class<?> componentClass() {
            throw new UnsupportedOperationException("Not implemented for property type" + this.name());
        }

        Object convert(String value) {
            throw new UnsupportedOperationException("Not implemented for property type" + this.name());
        }

        Object convert(PropType componentType, String value) {
            throw new UnsupportedOperationException("Not implemented for property type" + this.name());
        }
    }

    @Inherited
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Graph {
        public String[] value() default {};

        public NODE[] nodes() default {};

        public REL[] relationships() default {};
    }

    private static class DefaultNode
    extends Default
    implements NODE {
        private final LABEL[] labels;

        DefaultNode(String name, String[] labelNames) {
            super(name);
            this.labels = new LABEL[labelNames.length];
            for (int i = 0; i < labelNames.length; ++i) {
                this.labels[i] = new DefaultLabel(labelNames[i]);
            }
        }

        @Override
        public LABEL[] labels() {
            return this.labels;
        }
    }

    private static class NodeWithAddedLabels
    implements NODE {
        private final LABEL[] labels;
        private final NODE inner;

        NodeWithAddedLabels(NODE inner, String[] labelNames) {
            this.inner = inner;
            this.labels = new LABEL[labelNames.length];
            for (int i = 0; i < labelNames.length; ++i) {
                this.labels[i] = new DefaultLabel(labelNames[i]);
            }
        }

        @Override
        public String name() {
            return this.inner.name();
        }

        @Override
        public PROP[] properties() {
            return this.inner.properties();
        }

        @Override
        public LABEL[] labels() {
            return this.labels;
        }

        @Override
        public boolean setNameProperty() {
            return this.inner.setNameProperty();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.inner.annotationType();
        }
    }

    private static class DefaultRel
    extends Default
    implements REL {
        private final String start;
        private final String type;
        private final String end;

        DefaultRel(String start, String type, String end) {
            super(null);
            this.type = type;
            this.start = GraphDescription.defined(start);
            this.end = GraphDescription.defined(end);
        }

        @Override
        public String start() {
            return this.start;
        }

        @Override
        public String end() {
            return this.end;
        }

        @Override
        public String type() {
            return this.type;
        }
    }

    private static class DefaultLabel
    implements LABEL {
        private final String name;

        DefaultLabel(String name) {
            this.name = name;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("this is not a real annotation");
        }

        @Override
        public String value() {
            return this.name;
        }
    }

    private static class Default {
        private final String name;

        Default(String name) {
            this.name = "".equals(name) ? null : name;
        }

        public String name() {
            return this.name;
        }

        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("this is not a real annotation");
        }

        public PROP[] properties() {
            return NO_PROPS;
        }

        public boolean setNameProperty() {
            return true;
        }
    }
}

