/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;

public class AnonymousContext
extends LoginContext {
    private final AccessMode accessMode;

    private AnonymousContext(AccessMode accessMode) {
        super(AuthSubject.ANONYMOUS, ClientConnectionInfo.EMBEDDED_CONNECTION);
        this.accessMode = accessMode;
    }

    public static AnonymousContext access() {
        return new AnonymousContext((AccessMode)StaticAccessMode.ACCESS);
    }

    public static AnonymousContext read() {
        return new AnonymousContext((AccessMode)StaticAccessMode.READ);
    }

    public static AnonymousContext write() {
        return new AnonymousContext((AccessMode)StaticAccessMode.WRITE);
    }

    public static AnonymousContext writeToken() {
        return new AnonymousContext((AccessMode)StaticAccessMode.TOKEN_WRITE);
    }

    public static AnonymousContext writeOnly() {
        return new AnonymousContext((AccessMode)StaticAccessMode.WRITE_ONLY);
    }

    public static AnonymousContext full() {
        return new AnonymousContext((AccessMode)StaticAccessMode.FULL);
    }

    public SecurityContext authorize(LoginContext.IdLookup idLookup, PrivilegeDatabaseReference dbReference, AbstractSecurityLog securityLog) {
        return new SecurityContext(this.subject(), this.accessMode, this.connectionInfo(), dbReference.name());
    }
}

