/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Instant;
import java.util.function.IntConsumer;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DetachedCheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.entry.v522.DetachedCheckpointLogEntrySerializerV5_22;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;

public class CheckpointLogSerializationHelper {
    static final long CONFIG_ROTATION_THRESHOLD = ByteUnit.kibiBytes((long)1L);
    static final long ACTUAL_ROTATION_THRESHOLD = (long)LogSegments.DEFAULT_LOG_SEGMENT_SIZE * 2L;
    static final String CHECKPOINT_REASON = "checkpoint for rotation test";
    static final LogPosition LOG_POSITION = new LogPosition(1000L, 12345L);
    static final TransactionId TRANSACTION_ID = new TransactionId(100L, 101L, LatestVersions.LATEST_KERNEL_VERSION, 101, 102L, 103L);

    public static int getCheckpointRecordLengthBytes() {
        if (LatestVersions.LATEST_KERNEL_VERSION.isAtLeast(KernelVersion.VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED)) {
            return DetachedCheckpointLogEntrySerializerV5_22.checkPointRecordSizeDependingOnVersion((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION);
        }
        return 232;
    }

    public static int getExpectedPositionAfterOneCheckpoint() {
        return (int)LatestVersions.LATEST_LOG_FORMAT.getDefaultDataStartByteOffset() + CheckpointLogSerializationHelper.getCheckpointRecordLengthBytes();
    }

    public static long getMaxCheckpointFileSize() {
        if (LatestVersions.LATEST_KERNEL_VERSION.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
            return ACTUAL_ROTATION_THRESHOLD;
        }
        return ACTUAL_ROTATION_THRESHOLD + (long)CheckpointLogSerializationHelper.getCheckpointRecordLengthBytes() - 1L;
    }

    public static void fillWithCheckpoints(int files, CheckpointAppender appender) throws IOException {
        CheckpointLogSerializationHelper.fillWithCheckpointsWithCallback(files, appender, i -> {});
    }

    public static void fillWithCheckpointsWithCallback(int files, CheckpointAppender appender, IntConsumer afterAppend) throws IOException {
        DetachedCheckpointAppender detached = (DetachedCheckpointAppender)appender;
        for (int fileCount = 0; fileCount < files; ++fileCount) {
            long fullyFilledFileSize = LatestVersions.LATEST_LOG_FORMAT.usesSegments() ? ACTUAL_ROTATION_THRESHOLD - 31L : ACTUAL_ROTATION_THRESHOLD;
            do {
                appender.checkPoint(LogCheckPointEvent.NULL, TRANSACTION_ID, TRANSACTION_ID.id() + 77L, LatestVersions.LATEST_KERNEL_VERSION, LOG_POSITION, LOG_POSITION, Instant.now(), CHECKPOINT_REASON);
                afterAppend.accept(fileCount);
            } while (detached.getCurrentPosition() < fullyFilledFileSize);
        }
    }

    public static long expectedNewCheckpointFileSize() {
        return LatestVersions.LATEST_LOG_FORMAT.getDefaultDataStartByteOffset() + (long)CheckpointLogSerializationHelper.getCheckpointRecordLengthBytes();
    }
}

