/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import org.neo4j.internal.kernel.api.security.Segment;

public class UserSegment
implements Segment {
    private final String username;
    public static final UserSegment ALL = new UserSegment(null);

    public UserSegment(String username) {
        this.username = username;
    }

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof UserSegment) {
            UserSegment other = (UserSegment)segment;
            return this.username == null || this.username.equals(other.username);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSegment that = (UserSegment)o;
        return Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return this.username != null ? this.username.hashCode() : 0;
    }

    public String toString() {
        return this.username == null ? "*" : this.username;
    }
}

