/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public final class TokenLengthLimitExceededException
extends GqlRuntimeException {
    public TokenLengthLimitExceededException(String tokenName, String tokenType, int maxLength) {
        this(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I50).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.input, tokenName).withParam(GqlParams.StringParam.tokenType, tokenType).withParam(GqlParams.NumberParam.value, (Number)maxLength).build(), tokenName, tokenType, maxLength);
    }

    public TokenLengthLimitExceededException(ErrorGqlStatusObject errorGqlStatusObject, String tokenName, String tokenType, int maxLength) {
        super(errorGqlStatusObject, TokenLengthLimitExceededException.getMessage(tokenName, tokenType, maxLength));
    }

    private static String getMessage(String tokenName, String tokenType, int maxLength) {
        return String.format("Invalid input %s... A %s name cannot be longer than %d.", tokenName.substring(0, Math.min(tokenName.length(), 100)), tokenType, maxLength);
    }
}

